% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-keys.R
\name{valid_annotation_keys}
\alias{valid_annotation_keys}
\alias{valid_annotation_keys.NULL}
\alias{valid_annotation_keys.synapseclient.entity.File}
\alias{valid_annotation_keys.data.frame}
\alias{valid_annotation_keys.synapseclient.table.CsvFileTable}
\title{Valid annotation keys}
\usage{
valid_annotation_keys(x, annotations, ...)

\method{valid_annotation_keys}{`NULL`}(x, annotations, ...)

\method{valid_annotation_keys}{synapseclient.entity.File}(x, annotations, syn, ...)

\method{valid_annotation_keys}{data.frame}(x, annotations, ...)

\method{valid_annotation_keys}{synapseclient.table.CsvFileTable}(x, annotations, ...)
}
\arguments{
\item{x}{An object to check.}

\item{annotations}{A data frame of annotation definitions. Must contain at
least three columns: \code{key}, \code{value}, and \code{columnType}.}

\item{...}{Additional parameters passed to \code{\link[=check_keys]{check_keys()}}}

\item{syn}{Synapse client object}
}
\value{
A vector of valid annotation keys present in \code{x}.
}
\description{
Checks for and returns the valid annotation keys in a data framae, Synapse
file, or Synapse file view.
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: Return NULL

\item \code{synapseclient.entity.File}: Valid annotation keys on a Synapse file

\item \code{data.frame}: Valid annotation keys in a data frame

\item \code{synapseclient.table.CsvFileTable}: Valid annotation keys in a Synapse table
}}

\examples{
annots <- data.frame(
  key = c("assay", "fileFormat", "fileFormat", "fileFormat", "species"),
  value = c("rnaSeq", "fastq", "txt", "csv", "Human"),
  columnType = c("STRING", "STRING", "STRING", "STRING", "STRING")
)
dat1 <- data.frame(x = 1)
dat2 <- data.frame(assay = "rnaSeq")
valid_annotation_keys(dat1, annots)
valid_annotation_keys(dat2, annots)
}
