% Generated by roxygen2 (4.0.1): do not edit by hand
\name{GetParameterNames}
\alias{GetParameterNames}
\title{Parameter Names for All DCM Models}
\usage{
GetParameterNames(qmatrix, nattributes, parameterization.method = 'Mplus')
}
\arguments{
\item{qmatrix}{a matrix of size (nitems X nattributes) that specifies which items are required for mastery of each attribute (i.e., latent variable)}

\item{nattributes}{a numeric value of number of attriutes}

\item{parameterization.method}{optional character string of parameterization method used to calibrated parameters.
If not specified then the default will be set to  \code{Mplus}}
}
\value{
a string vector of threshold parameter names
}
\description{
Given a Q-matrix and parameterization method it generates item and structural parameter names. These are non-kernel parameters:
item thresholds (\code{taus}) and latent variable thresholds (\code{nus})
}
\examples{
\dontrun{

 GetParameterNames(qmatrix = qmatrix.test, nattributes=3)
}
}
\author{
Margi Dubal \email{margidubal@gmail.com} & Diane Losardo \email{dlosardo@amplify.com}
}

