% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centering.R
\name{centering}
\alias{centering}
\alias{centering_from_data}
\title{Centering method
This method implements the double centering and U-centering
during computing distance covariance.}
\usage{
centering(D, type = c("V", "U"))

centering_from_data(x, type = c("V", "U"))
}
\arguments{
\item{D}{the pairwise distance matrix}

\item{type}{"V" or "U". "V" for double centering. "U" for U-centering.}

\item{x}{the matrix of x}
}
\description{
Centering method
This method implements the double centering and U-centering
during computing distance covariance.
}
\examples{
x = matrix(rnorm(200),100,2)
D = as.matrix(dist(x))
A = centering(D,'U')
A = centering_from_data(x)

}
