% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dobject.R
\name{psize}
\alias{psize}
\title{Return sizes of each partition of the input distributed object.}
\usage{
psize(dobj, index = NULL)
}
\arguments{
\item{dobj}{input distributed object}

\item{index}{a numeric vector or list containing the indices of the partitions. Default is NULL.}
}
\value{
A matrix that denotes the number of rows and columns in the
partition. Row i of the matrix corresponds or size of i'th partition. For a dlist, the returned matrix has only 1 column.
}
\description{
Return sizes of each partition of the input distributed object.
}
\examples{
\dontrun{
a <- darray(psize=c(3,3),dim=c(9,9)) # 9 partitions of 3x3
b <- psize(a) # A 9x2 matrix, with each row containing c(3,3)
}
}
\references{
Prasad, S., Fard, A., Gupta, V., Martinez, J., LeFevre, J., Xu, V., Hsu, M., Roy, I.
Large scale predictive analytics in Vertica: Fast data transfer, distributed model creation
and in-database prediction. _Sigmod 2015_, 1657-1668.

Venkataraman, S., Bodzsar, E., Roy, I., AuYoung, A., and
Schreiber, R. (2013) Presto: Distributed Machine Learning and
Graph Processing with Sparse Matrices. _EuroSys 2013_, 197-210.

Homepage: https://github.com/vertica/ddR
}
\seealso{
\code{\link{nparts}}, \code{\link{parts}}
}

