% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_wrappers.R
\name{mdl_glm}
\alias{mdl_glm}
\title{Wrapper for \code{\link[stats:glm]{stats::glm()}}.}
\usage{
mdl_glm(y, X, ...)
}
\arguments{
\item{y}{The outcome variable.}

\item{X}{The feature matrix.}

\item{...}{Additional arguments passed to \code{glm}. See
\code{\link[stats:glm]{stats::glm()}} for a complete list of arguments.}
}
\value{
\code{mdl_glm} returns an object of S3 class \code{mdl_glm} as a
simple mask of the return object of \code{\link[stats:glm]{stats::glm()}}.
}
\description{
Simple wrapper for \code{\link[stats:glm]{stats::glm()}}.
}
\examples{
glm_fit <- mdl_glm(sample(0:1, 100, replace = TRUE),
                   matrix(rnorm(1000), 100, 10))
class(glm_fit)
}
\seealso{
\code{\link[stats:glm]{stats::glm()}}

Other ml_wrapper: 
\code{\link{mdl_glmnet}()},
\code{\link{mdl_ranger}()},
\code{\link{mdl_xgboost}()},
\code{\link{ols}()}
}
\concept{ml_wrapper}
