% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{save_plate}
\alias{save_plate}
\title{Save a ddPCR plate}
\usage{
save_plate(plate, file)
}
\arguments{
\item{plate}{Plate object to save.}

\item{file}{Name of the file where the plate will be saved.}
}
\value{
The given plate, unchanged.
}
\description{
Saves a plate to a file, including all its data, parameters, and current
analysis state.  The file can be read back later using 
\code{\link[ddpcr]{load_plate}}.  The file is not human-readable - if
you want to save the droplets data or the metadata of a plate, then first
retrieve the data using \code{\link[ddpcr]{plate_data}} or
\code{\link[ddpcr]{plate_meta}} and save it with 
\code{\link[utils]{write.csv}}.
}
\examples{
plate <- new_plate(sample_data_dir())
save_plate(plate, "myplate")
unlink("myplate.rds")
}
\seealso{
\code{\link[ddpcr]{load_plate}}
}
