% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{plate_meta}
\alias{plate_meta}
\title{Plate metadata}
\usage{
plate_meta(plate, only_used = FALSE)
}
\arguments{
\item{plate}{A ddPCR plate}

\item{only_used}{If \code{TRUE}, only return metadata for wells that are
used in this plate (wells that have any data)}
}
\value{
A dataframe containing the plate metadata
}
\description{
The metadata is a collection of variables that describe each well in the plate.
The metadata of an unanalyzed plate only contains basic information about each
well, such as the sample name, whether the well was used, and the number of
droplets in the well. Analyzing a plate adds many more variables to the metadata,
such as the number of empty droplets, the number of outliers, the template
concentration, and more.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())
plate \%>\% plate_meta(only_used = TRUE)
plate \%>\% analyze \%>\% plate_meta(only_used = TRUE)
}
}
\seealso{
\code{\link[ddpcr]{plate_data}}
\code{\link[ddpcr]{plot.ddpcr_plate}}
}
