% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Economy}
\alias{Economy}
\title{Data: Wang and Lan (2011).}
\format{
Data frame with 31 rows and 16 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1 = Capital}{Total assets (in 100 million RMB)}
  \item{x2 = Labor}{Annual average employed persons (in 10000 persons)}
  \item{y1 = GIOV}{Gross industrial output value (in 100 million RMB)}
}
}
\source{
Wang, Y.; Lan, Y. (2011). "Measuring Malmquist Productiviy Index: A New
Approach Based on Double Frontiers Data Envelopment Analysis". Mathematical and
Computer Modelling, 54, 2760-2771. \doi{10.1016/j.mcm.2011.06.064}
}
\usage{
data("Economy")
}
\description{
Data of the industrial economy of China in 2005-2009 (data in wide format).
}
\examples{
# Example . Data in wide format.
# Replication of results in Wang and Lan (2011, p. 2768)
data("Economy")
data_example <- make_malmquist(Economy,
                               nper = 5,
                               arrangement = "horizontal",
                               ni = 2,
                               no = 1)
result <- malmquist_index(data_example)

}
\seealso{
\code{\link{make_malmquist}}, \code{\link{malmquist_index}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
