% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdistq_fit.R
\name{rdistq_fit}
\alias{rdistq_fit}
\title{Quantiles based univariate random number generation (by parameter fitting).}
\usage{
rdistq_fit(distribution, n, percentiles = c(0.05, 0.5, 0.95), quantiles,
  relativeTolerance = 0.05, tolConv = 0.001, fit.weights = rep(1,
  length(percentiles)), verbosity = 1)
}
\arguments{
\item{distribution}{A character string that defines the univariate distribution
to be randomly sampled.}

\item{n}{Number of generated observations.}

\item{percentiles}{Numeric vector giving the percentiles.}

\item{quantiles}{Numeric vector giving the quantiles.}

\item{relativeTolerance}{\code{numeric}; the relative tolerance level of deviation of the
generated individual percentiles from the specified percentiles. If any deviation is greater 
than \code{relativeTolerance} a warning is given.}

\item{tolConv}{positive numerical value, the absolute convergence tolerance for reaching zero by fitting distributions
\code{get.norm.par} will be shown.}

\item{fit.weights}{numerical vector of the same length as a probabilities vector 
\code{p} containing positive values for weighting quantiles. By default all
quantiles will be weighted by 1.}

\item{verbosity}{\code{integer}; if \code{0} the function is silent; the larger the value the
more verbose is the output information.}
}
\value{
A numeric vector of length \code{n} with the sampled values according to the chosen 
  distribution.
}
\description{
This function generates random numbers for a set of univariate parametric distributions from  
given quantiles. Internally, this is achieved by fitting the distribution function
to the given quantiles.
}
\details{
The following table shows the available distributions and their identification 
 (option: \code{distribution}) as a character string:
 \tabular{llll}{
 \bold{\code{distribution}}  \tab  \bold{Distribution Name}                 \tab \bold{\code{length(quantiles)}} \tab \bold{Necessary Package}\cr
 \code{"norm"}       \tab  \link{Normal}                                    \tab >=2    \tab \cr
 \code{"beta"}       \tab  \link{Beta}                                      \tab >=2    \tab \cr  
 \code{"cauchy"}     \tab  \link{Cauchy}                                    \tab >=2    \tab \cr
 \code{"logis"}      \tab  \link{Logistic}                                  \tab >=2    \tab \cr 
 \code{"t"}          \tab  \link[=TDist]{Student t}                         \tab >=1    \tab \cr 
 \code{"chisq"}      \tab  \link[=Chisquare]{Central Chi-Squared}           \tab >=1    \tab \cr 
 \code{"chisqnc"}    \tab  \link[=Chisquare]{Non-central Chi-Squared}       \tab >=2    \tab \cr 
 \code{"exp"}        \tab  \link{Exponential}                               \tab >=1    \tab \cr    
 \code{"f"}          \tab  \link[=FDist]{Central F}                         \tab >=2    \tab \cr 
 \code{"gamma"}      \tab  \link[=GammaDist]{Gamma} with \code{scale=1/rate}\tab >=2    \tab \cr
 \code{"lnorm"}      \tab  \link[=Lognormal]{Log Normal}                    \tab >=2    \tab \cr
 \code{"unif"}       \tab  \link{Uniform}                                   \tab ==2    \tab \cr
 \code{"weibull"}    \tab  \link{Weibull}                                   \tab >=2    \tab \cr
 \code{"triang"}     \tab  \link[mc2d:triangular]{Triangular}               \tab >=3    \tab \pkg{\code{mc2d}}\cr
 \code{"gompertz"}   \tab  \link[eha:Gompertz]{Gompertz}                    \tab >=2    \tab \pkg{\code{eha}} \cr
 \code{"pert"}       \tab  \link[mc2d:pert]{(Modified) PERT}                \tab >=4    \tab \pkg{\code{mc2d}}\cr
 \code{"tnorm"}      \tab  \link[msm:tnorm]{Truncated Normal}               \tab >=4    \tab \pkg{\code{msm}}
 }
 
 \code{percentiles} and \code{quantiles} must be of the same length. \code{percentiles} must be 
 \code{>=0} and \code{<=1}.
 
 
The default for \code{percentiles} is 0.05, 0.5 and 0.95, so for the default, 
the quantiles argument should be a vector with 3 elements. If this is to be longer,
the percentiles argument has to be adjusted to match the length of quantiles.

 The fitting of the distribution parameters is done using 
 \code{\link[rriskDistributions]{rriskFitdist.perc}}.
}
\examples{
# Fit a log normal distribution to 3 quantiles:
if ( requireNamespace("rriskDistributions", quietly = TRUE) ){
  percentiles<-c(0.05, 0.5, 0.95)
  quantiles=c(1,3,15)
  hist(r<-rdistq_fit(distribution="lnorm", n=10000, quantiles=quantiles),breaks=100)
  print(quantile(x=r, probs=percentiles))
}
}
\seealso{
\code{\link[rriskDistributions]{rriskFitdist.perc}}
}
