% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_undeclare.R
\name{drop_undeclare}
\alias{drop_undeclare}
\alias{undeclare}
\alias{drop_na}
\title{Drop information / undeclare labelled objects}
\usage{
undeclare(x, drop = FALSE, ...)

drop_na(x, drop_labels = TRUE)
}
\arguments{
\item{x}{A labelled object with declared missing values}

\item{drop}{Logical, drop all attributes}

\item{...}{Other internal arguments}

\item{drop_labels}{Logical, drop the labels for the declared missing values}
}
\value{
A declared labelled object.
}
\description{
A function to obtain a version of the object with all information about
declared missing values, dropped
}
\details{
#' The function \code{undeclare()} replaces the NA entries into their original
numeric values, and drops all attributes related to missing values:
\code{na_values}, \code{na_range} and \code{na_index}, and it preserves the labels referring
to the missing values.

The result can be a regular vector (dropping all attributes, including the
class "declared") by activating the argument \code{drop}.

Function \code{drop_na()} transforms the declared missing values in regular empty
NAs, and the labels referring to the missing values are deleted by default.

Function \code{drop()} deletes all attributes.
}
\examples{
x <- declared(
    c(-2, 1:5, -1),
    labels = c("Good" = 1, "Bad" = 5, "DK" = -1),
    na_values = c(-1, -2),
    label = "Test variable"
)

x

undeclare(x)

drop_na(x)

drop(x)

undeclare(x, drop = TRUE)

# similar to:
drop(undeclare(x))
}
\seealso{
Other labelling functions: 
\code{\link{labels}()},
\code{\link{measurement}()}
}
\concept{labelling functions}
