% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorator-time_it.R
\name{time_it}
\alias{time_it}
\title{Measure Execution Time of Functions}
\usage{
time_it(func, units = "auto", digits = 2)
}
\arguments{
\item{func}{(\code{function}) A function to decorate.}

\item{units}{(\code{character}) Units in which the results are desired, including:
\code{"auto"}, \code{"secs"}, \code{"mins"}, \code{"hours"}, \code{"days"},
and \code{"weeks"}. See \link[base]{difftime}.}

\item{digits}{(\code{integer}) The number of significant digits to be used. See
\link[base]{signif}.}
}
\value{
(\code{closure}) An object that contains the original function bound to the environment of the decorator.
}
\description{
Wrap a function with a timer.
}
\examples{
Sys.sleep <- time_it(base::Sys.sleep)
Sys.sleep(0.1)
}
\references{
\itemize{
\item \href{https://docs.python.org/3/library/timeit.html}{timeit Python module}
\item \href{http://adv-r.had.co.nz/Functional-programming.html}{Closures in R}
}
}
\concept{misc decorators}
