% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularisation.R
\name{no_regularisation}
\alias{no_regularisation}
\title{no_regularisation function}
\usage{
no_regularisation()
}
\value{
list containing functions to evaluate the cost modifier and grandient modifier
}
\description{
A function to return the no regularisation strategy for a network object.
}
\examples{

# Example in context: NOTE with the network function
# no_regularisation() is the default, so this argument
# actually need not be included

net <- network( dims = c(784,16,16,10),
                regulariser = no_regularisation(),
                activ=list(ReLU(),logistic(),softmax()))

}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{L1_regularisation}, \link{L2_regularisation}
}
