% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deeptree.R
\name{deeptree}
\alias{deeptree}
\title{Descision Tree augmented by Artificial Neural Network}
\usage{
deeptree(
  x,
  y,
  hiddenLayerUnits = c(2, 2),
  activation = c("sigmoid", "sigmoid"),
  reluLeak = 0,
  modelType = "regress",
  iterations = 500,
  eta = 10^-2,
  seed = 2,
  gradientClip = 0.8,
  regularisePar = 0,
  optimiser = "adam",
  parMomentum = 0.9,
  inputSizeImpact = 1,
  parRmsPropZeroAdjust = 10^-8,
  parRmsProp = 0.9999,
  treeLeaves = NA,
  treeMinSplitPercent = 0.3,
  treeMinSplitCount = 30,
  treeCp = 0.01,
  stackPred = NA,
  printItrSize = 100,
  showProgress = TRUE,
  stopError = 0.01,
  miniBatchSize = NA,
  useBatchProgress = TRUE,
  ignoreNAerror = FALSE
)
}
\arguments{
\item{x}{a data frame with input variables}

\item{y}{a data frame with ouptut variable}

\item{hiddenLayerUnits}{a numeric vector, length of vector indicates number of hidden layers and each element in vector indicates corresponding hidden units Eg: c(6,4) for two layers, one with 6 hiiden units and other with 4 hidden units. Note: Output layer is automatically created.}

\item{activation}{one of "sigmoid","relu","sin","cos","none". The default is "sigmoid". Choose a activation per hidden layer}

\item{reluLeak}{numeric. Applicable when activation is "relu". Specify value between 0 any number close to zero below 1. Eg: 0.01,0.001 etc}

\item{modelType}{one of "regress","binary","multiClass". "regress" for regression will create a linear single unit output layer. "binary" will create a single unit sigmoid activated layer. "multiClass" will create layer with units corresponding to number of output classes with softmax activation.}

\item{iterations}{integer. This indicates number of iteratios or epochs in backpropagtion .The default value is 500.}

\item{eta}{numeric.Hyperparameter,sets the Learning rate for backpropagation. Eta determines the convergence ability and speed of convergence.}

\item{seed}{numeric. Set seed with this parameter. Incase of sin activation sometimes changing seed can yeild better results. Default is 2}

\item{gradientClip}{numeric. Hyperparameter numeric value which limits gradient size for weight update operation in backpropagation. Default is 0.8 . It can take any postive value.}

\item{regularisePar}{numeric. L2 Regularisation Parameter .}

\item{optimiser}{one of "gradientDescent","momentum","rmsProp","adam". Default value "adam"}

\item{parMomentum}{numeric. Applicable for optimiser "mometum" and "adam"}

\item{inputSizeImpact}{numeric. Adjusts the gradient size by factor of percentage of rows in input. For very small data set setting this to 0 could yeild faster result. Default is 1.}

\item{parRmsPropZeroAdjust}{numeric. Applicable for optimiser "rmsProp" and "adam"}

\item{parRmsProp}{numeric.Applicable for optimiser "rmsProp" and "adam"}

\item{treeLeaves}{vector.Optional , leaves numbers from externally trained tree model can be supplied here. If supplied then model will not build a explicit tree and just fit a neural network to mentioned leaves.}

\item{treeMinSplitPercent}{numeric. This parameter controls depth of tree setting min split count for leaf subdivision as percentage of observations. Final minimum split will be chosen as max of count calculted with treeMinSplitPercent and treeMinSplitCount. Default 0.3. Range 0 to 1.}

\item{treeMinSplitCount}{numeric. This parameter controls depth of tree setting min split count.Final minimum split will be chosen as max of count calculted with treeMinSplitPercent and treeMinSplitCount. Default 30}

\item{treeCp}{complexity parameter. \code{\link{rpart.control}}}

\item{stackPred}{vector.Predictions from buildnet or other models can be supplied here. If for certain leaf stackPrep accuracy is better then stackpred predictions will be chosen.}

\item{printItrSize}{numeric. Number of iterations after which progress message should be shown. Default value 100 and for iterations below 100 atleast 5 messages will be seen}

\item{showProgress}{logical. True will show progress and F will not show progress}

\item{stopError}{Numeric. Rmse at which iterations can be stopped. Default is 0.01, can be set as NA in case all iterations needs to run.}

\item{miniBatchSize}{integer. Set the mini batch size for mini batch gradient}

\item{useBatchProgress}{logical. Applicable for miniBatch , setting T will use show rmse in Batch and F will show error on full dataset. For large dataset set T}

\item{ignoreNAerror}{logical. Set T if iteration needs to be stopped when predictions become NA}
}
\value{
returns model object which can be passed into \code{\link{predict.deeptree}}
}
\description{
This models divides the input space by fitting a tree followed by artificial neural network to each of leaf. Decision tree model is built using rpart package and neural network using deepdive.Feature of stacking predictions from other models is also made available.
}
\examples{

require(deepdive)

x <- data.frame(x1 = runif(10),x2 = runif(10))

y<- data.frame(y=20*x$x1 +30* x$x2 +10)

deepTreeMod<-deeptree(x,
y,
hiddenLayerUnits=c(4,4),
activation = c('relu',"sin"),
reluLeak=0.01,
modelType ='regress',
iterations = 1000,
eta = 0.4,
seed=2,
gradientClip=0.8,
regularisePar=0,
optimiser="adam",
parMomentum=0.9,
inputSizeImpact=1,
parRmsPropZeroAdjust=10^-8,
parRmsProp=0.9999,
treeLeaves=NA,
treeMinSplitPercent=0.4,
treeMinSplitCount=100,
stackPred =NA,
stopError=4,
miniBatchSize=64,
useBatchProgress=TRUE,
ignoreNAerror=FALSE)

}
