% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_color.R
\docType{data}
\name{facet_grid_color}
\alias{facet_grid_color}
\alias{facet_grid_geo}
\alias{FacetGridColor}
\title{Lay out panels in a grid with colored strips}
\usage{
facet_grid_color(
  colors,
  rows = NULL,
  cols = NULL,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  lab_colors = "auto",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  margins = FALSE,
  axes = "margins",
  axis.labels = "all"
)

facet_grid_geo(
  colors = stages,
  rows = NULL,
  cols = NULL,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  lab_colors = "auto",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  margins = FALSE,
  axes = "margins",
  axis.labels = "all"
)
}
\arguments{
\item{colors}{Specifies which colors to use to replace the strip backgrounds.
Either A) a function that returns a color for a given strip label, B) the
character name of a function that does the same, C) a named character
vector with names matching strip labels and values indicating the desired
colors, or D) a data.frame representing a lookup table with columns named
"name" (matching strip labels) and "color" (indicating desired colors). If
the function returns \code{NA}, the default background color will be used.}

\item{rows, cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{space}{If \code{"fixed"}, the default, all panels have the same size.
If \code{"free_y"} their height will be proportional to the length of the
y scale; if \code{"free_x"} their width will be proportional to the
length of the x scale; or if \code{"free"} both height and width will
vary.  This setting has no effect unless the appropriate scales also vary.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{lab_colors}{Specifies which colors to use for the strip labels. Either
A) a function that returns a color for a given strip label, B) the
character name of a function that does the same, C) a named character
vector with names matching strip labels and values indicating the desired
colors, D) a data.frame representing a lookup table with columns named
"name" (matching strip labels) and "lab_color" (indicating desired colors),
or E) "auto" (the default), which set the labels to black or white,
whichever has better contrast with the background color, based on
\href{https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en}{recommendations by the International Telecommunication Union}.
If the function returns \code{NA}, the default label color will be used.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{axes}{Determines which axes will be drawn. When \code{"margins"}
(default), axes will be drawn at the exterior margins. \code{"all_x"} and
\code{"all_y"} will draw the respective axes at the interior panels too, whereas
\code{"all"} will draw all axes at all panels.}

\item{axis.labels}{Determines whether to draw labels for interior axes when
the \code{axes} argument is not \code{"margins"}. When \code{"all"} (default), all
interior axes get labels. When \code{"margins"}, only the exterior axes get
labels and the interior axes get none. When \code{"all_x"} or \code{"all_y"}, only
draws the labels at the interior axes in the x- or y-direction
respectively.}
}
\description{
\code{facet_grid_color} behaves similarly to \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} in that it
forms a matrix of panels defined by row and column faceting variables. The
main difference is that it also allows the user to specify the background and
label colors of the individual facet strips using the \code{colors} and
\code{lab_colors} arguments. If you have only one variable with many levels, try
\code{\link[=facet_wrap_color]{facet_wrap_color()}}.
}
\details{
\code{facet_grid_geo(...)} is an alias of \code{facet_grid_color()} with the default of
\code{colors} set to \code{stages}.
}
\examples{
library(ggplot2)
df <- data.frame(x = 1:10, y = 1:10, period = c("Permian", "Triassic"))
ggplot(df) +
  geom_point(aes(x, y)) +
  facet_grid_color(cols = vars(period), colors = periods)
}
\seealso{
Other faceting functions: 
\code{\link{facet_nested_color}()},
\code{\link{facet_nested_wrap_color}()},
\code{\link{facet_wrap_color}()}
}
\concept{faceting functions}
\keyword{datasets}
