% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_trans_flip.R
\docType{data}
\name{coord_trans_flip}
\alias{coord_trans_flip}
\alias{CoordTransFlip}
\title{Transformed and flipped Cartesian coordinate system}
\usage{
coord_trans_flip(
  x = "identity",
  y = "identity",
  xlim = NULL,
  ylim = NULL,
  clip = "on",
  expand = TRUE
)
}
\arguments{
\item{x, y}{Transformers for x and y axes or their names.}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.
Giving a logical vector will separately control the expansion for the four
directions (top, left, bottom and right). The \code{expand} argument will be
recycled to length 4 if necessary. Alternatively, can be a named logical
vector to control a single direction, e.g. \code{expand = c(bottom = FALSE)}.}
}
\description{
\code{coord_trans_flip} behaves similarly to \code{\link[ggplot2:coord_transform]{ggplot2::coord_trans()}} in that it
occurs after statistical transformation and will affect the visual appearance
of geoms. The main difference is that it also flips the x and y coordinates
like \code{\link[ggplot2:coord_flip]{ggplot2::coord_flip()}}.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(disp, wt)) +
  geom_point() +
  coord_trans_flip(x = "log10", y = "log10")
}
\keyword{datasets}
