/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Peak;
import java.util.ArrayList;
import java.util.List;

public class IsotopicCluster {
    private List<Peak> isotopicCluster = new ArrayList<Peak>();
    private int charge;
    private int clusterId;
    private String status;

    public Peak getPeak(int i) {
        return this.isotopicCluster.get(i);
    }

    public int size() {
        return this.isotopicCluster.size();
    }

    public int getClusterID() {
        return this.clusterId;
    }

    public void setClusterID(int clusterId) {
        this.clusterId = clusterId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCharge() {
        return this.charge;
    }

    public List<Peak> getIsotopicCluster() {
        return this.isotopicCluster;
    }

    public IsotopicCluster(List<Peak> isotopicCluster, int charge, Configuration config) {
        try {
            IsotopicCluster.rangeCheck(isotopicCluster, config, charge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isotopicCluster = isotopicCluster;
        this.charge = charge;
    }

    public IsotopicCluster(String status) {
        this.isotopicCluster = null;
        this.charge = 0;
        this.status = status;
    }

    public IsotopicCluster aggregation(String modus) {
        if (modus.equals("first")) {
            return this.aggregateFirst();
        }
        if (modus.equals("highest")) {
            return this.aggregateHighest();
        }
        throw new IllegalArgumentException("Modus not found (" + modus + ")");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(" + this.clusterId + ") [ ");
        if (this.isotopicCluster == null) {
            return this.status;
        }
        for (Peak p : this.isotopicCluster) {
            stringBuilder.append(p.getMz() + " ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean isNotNull() {
        return this.isotopicCluster != null;
    }

    public boolean isNull() {
        return this.isotopicCluster == null;
    }

    private IsotopicCluster aggregateFirst() {
        double intensitySum = this.sumIntensity();
        return this.rearrangeCluster(intensitySum);
    }

    private IsotopicCluster aggregateHighest() {
        double intensitySum = this.sumIntensity();
        double minIntensity = 0.0;
        double minMz = 0.0;
        for (Peak peak : this.isotopicCluster) {
            if (!(peak.getIntensity() > minIntensity)) continue;
            minIntensity = peak.getIntensity();
            minMz = peak.getMz();
        }
        this.isotopicCluster.get(0).setMz(minMz);
        return this.rearrangeCluster(intensitySum);
    }

    private IsotopicCluster rearrangeCluster(double intensitySum) {
        this.isotopicCluster.get(0).setIntensity(intensitySum);
        if (this.isotopicCluster.size() == 2) {
            this.isotopicCluster.remove(1);
        } else if (this.isotopicCluster.size() == 3) {
            this.isotopicCluster.remove(2);
            this.isotopicCluster.remove(1);
        }
        return this;
    }

    private double sumIntensity() {
        double intensitySum = 0.0;
        for (Peak peak : this.isotopicCluster) {
            intensitySum += peak.getIntensity();
        }
        return intensitySum;
    }

    private static void rangeCheck(List<Peak> peaks, Configuration config, int charge) throws Exception {
        for (int i = 0; i < peaks.size() - 1; ++i) {
            double distance = peaks.get(i + 1).getMz() - peaks.get(i).getMz();
            if (config.getDistance() / (double)charge - config.getDelta() < Math.abs(distance) && Math.abs(distance) < config.getDistance() / (double)charge + config.getDelta()) continue;
            throw new Exception("Wrong distance at IsotopicCluster creation! (" + distance + ")");
        }
    }
}

