/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Connection;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.Peak;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

public class ScoreFive {
    private DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph;
    private Configuration config;

    public ScoreFive(DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph, Configuration config) {
        this.isotopicClusterGraph = isotopicClusterGraph;
        this.config = config;
    }

    public double calculateFifthScore(Connection connection) {
        return this.config.getF(5) * (double)ScoreFive.calculateScoreBasedOnExperimentalIsotopicDistribution(connection, this.isotopicClusterGraph, this.config);
    }

    public static int calculateScoreBasedOnExperimentalIsotopicDistribution(Connection connection, DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph, Configuration config) {
        int f5 = 0;
        double threshold = 0.3;
        int i = 0;
        for (Peak peak : ((IsotopicCluster)isotopicClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
            double tMin = peak.getMz() / config.getAspMass() * peak.getIntensity();
            double tMean = peak.getMz() / config.getAveUpdatedMass() * peak.getIntensity();
            double tMeanOverlap = ScoreFive.calculateTMeanOverlap(isotopicClusterGraph, connection, i, peak, config);
            double tMax = peak.getMz() / config.getPheMass() * peak.getIntensity();
            if (connection.getColor() == "black" && Math.min(Math.abs(peak.getIntensity() - tMin), Math.abs(peak.getIntensity() - tMax)) / tMean <= threshold) {
                ++f5;
            }
            if (connection.getColor() == "red" && Math.min(Math.abs(peak.getIntensity() - tMeanOverlap - tMin), Math.abs(peak.getIntensity() - tMeanOverlap - tMax)) / tMean <= threshold) {
                ++f5;
            }
            ++i;
        }
        return f5;
    }

    private static double calculateTMeanOverlap(DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph, Connection connection, int i, Peak peak, Configuration config) {
        double tMeanOverlap = 0.0;
        if (((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).isNotNull()) {
            tMeanOverlap = i < ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).size() ? ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).getPeak(i).getMz() / config.getAveUpdatedMass() * peak.getIntensity() : ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).getPeak(((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).size() - 1).getMz() / config.getAveUpdatedMass() * peak.getIntensity();
        }
        return tMeanOverlap;
    }
}

