% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{Voronoi}
\alias{Voronoi}
\title{Voronoï diagram}
\usage{
Voronoi(triangulation)
}
\arguments{
\item{triangulation}{a 2D Delaunay triangulation obtained with the 
\code{\link{delaunay}} function}
}
\value{
The Voronoï diagram given as list of pairs; each pair is made of 
  one site (a vertex of the Delaunay triangulation) and one Voronoï cell, 
  a polygon given as numeric matrix with two columns (that can be plotted 
  with \code{\link[graphics:polygon]{polygon}}).
}
\description{
Returns the Voronoï tessellation corresponding to a 2D 
  Delaunay triangulation. If the Delaunay triangulation is constrained, 
  the output is not a true constrained Voronoï tessellation.
}
\examples{
library(delaunay)
# make the vertices
nsides <- 6L
angles <- seq(0, 2*pi, length.out = nsides+1L)[-1L]
outer_points <- cbind(cos(angles), sin(angles))
inner_points <- outer_points / 4
nsides <- 12L
angles <- seq(0, 2*pi, length.out = nsides+1L)[-1L]
middle_points <- cbind(cos(angles), sin(angles)) / 2
points <- rbind(outer_points, inner_points, middle_points)
angles <- angles + pi/24
middle_points <- cbind(cos(angles), sin(angles)) / 3
points <- rbind(points, middle_points)
middle_points <- cbind(cos(angles), sin(angles)) / 1.5
points <- rbind(points, middle_points)
# constraint edges
indices <- 1L:6L
edges <- cbind(
  indices, c(indices[-1L], indices[1L])
)
edges <- rbind(edges, edges + 6L)
## | constrained Delaunay triangulation 
del <- delaunay(points, constraints = edges)
opar <- par(mar = c(0,0,0,0))
plotDelaunay2D(
  del, type = "n", xlab = NA, ylab = NA, axes = FALSE, asp = 1,
  fillcolor = "random", luminosity = "dark", 
  col_borders = "black", lwd_borders = 3
)
par(opar)
## | corresponding Voronoï diagram
vor <- Voronoi(del)
opar <- par(mar = c(0,0,0,0))
plot(
  NULL, asp = 1, axes = FALSE, xlab = NA, ylab = NA, 
  xlim = c(-1.5, 1.5), ylim = c(-1.5, 1.5) 
)
plotVoronoi(vor, luminosity = "dark")
points(points, pch = 19)
par(opar)
}
\seealso{
\code{\link{plotVoronoi}}
}
