% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_delim.R
\name{report_delim}
\alias{report_delim}
\title{Report Unique Species Partitions}
\usage{
report_delim(delim, verbose = TRUE)
}
\arguments{
\item{delim}{Output from any \verb{*_tbl()} (e.g. \link{gmyc_tbl}), \link{delim_join} or \link{delim_consensus}.}

\item{verbose}{Logical. If TRUE, returns a message and a tabulated summary of \code{delim}.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}].
}
\description{
\code{report_delim()} reports the number of unique species partitions in \code{delim}.
}
\details{
For each column in \code{delim}, \code{report_delim()} will calculate the
number of unique partitions and print them to \code{Console}. If \code{delim} is an output from \verb{*_tbl()},
\code{report_delim()} will get unique species partitions using \link[vctrs:vec_unique]{vec_unique_count}.
If \code{delim} is an output from \link{delim_join} or \link{delim_consensus}, values are summarized by using
\link[dplyr:n_distinct]{n_distinct} with \code{na.rm = TRUE}. This is to prevent any columns with
NA values to be interpreted as species partitions.
}
\examples{

# report geophagus delimitations
report_delim(geophagus_delims)

}
\author{
Rupert A. Collins, Pedro S. Bittencourt
}
