% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vdem.R
\name{get_vdem}
\alias{get_vdem}
\title{Download V-Dem (Current Version)}
\usage{
get_vdem(write_out = FALSE)
}
\arguments{
\item{write_out}{Logical to write the V-Dem dataset to your local directory.}
}
\value{
A data.frame of V-Dem data.
}
\description{
Download a copy of the most recent version of V-Dem that is housed
in the official vdemdata GitHub package.
}
\details{
This function is a simple download wrapper to directly acquire
V-Dem's current dataset from their GitHub repo. The vdemdata package is not
available on CRAN or Bioconductor so it can disrupt workflows that do not
permit non-standard package installations. Additionally, this function
contains test scripts that will notify the package manager if the remote
dataset undergoes significant structural changes (dimensions, location, etc.)
}
\examples{

\donttest{
vdem <- demcon::get_vdem(write_out = FALSE)}

}
