% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\docType{package}
\name{denvax}
\alias{denvax}
\alias{denvax-package}
\title{denvax: Simple Dengue Test and Vaccinate Cost Thresholds}
\description{
Provides the mathematical model described by "Serostatus Testing & Dengue Vaccine Cost-Benefit Thresholds"
in \href{https://arxiv.org/abs/1904.00214}{<arXiv:1904.00214>}.  Using the functions in the package,
that analysis can be repeated using sample life histories, either synthesized from local seroprevalence data
using other functions in this package (as in the manuscript) or from some other source.
The package provides a vignette which walks through the analysis in the publication, as well as a function
to generate a project skeleton for such an analysis.
}
\section{\code{denvax} functions}{

\describe{
  \item{\code{\link{serofit}}}{fits serosurvey data against two-risk model}
  \item{\code{\link{synthetic.pop}}}{using parameter fit data, generate a sample population}
  \item{\code{\link{nPxA}}}{estimate dengue infection outcome probabilities based on a synthetic population}
  \item{\code{\link{ROIcoeffs}}}{using population outcome probabilities, compute ROI equation coefficients}
  \item{\code{\link{ROI}}}{compute ROIs from setting coefficients and cost scenarios}
  \item{\code{\link{build.project}}}{create a template project for estimating ROIs}
}
}

