% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{nPxA}
\alias{nPxA}
\title{Compute the nPx(A), C(A) proportions from a population of life histories}
\usage{
nPxA(lifehistory)
}
\arguments{
\item{lifehistory, }{a matrix with rows (sample individuals) and columns (outcome in year of life); see \link{synthetic.pop} return value}
}
\value{
a \code{\link[base]{data.frame}} (\code{\link[data.table]{data.table}}, if available) with columns
\describe{
  \item{A}{integer; the reference year of life, from 1 to \code{dim(lifehistory)[2]}}
  \item{p_0}{numeric; probability of 0 lifetime infections}
  \item{p_1p}{numeric; probability of 1 or more lifetime infections}
  \item{p_2p}{numeric; probability of 2 or more lifetime infections}
  \item{p0_1}{numeric; probability of 0 infections at age A, and 1 lifetime infection}
  \item{p0_1p}{numeric; probability of 0 infections at age A, and 1 or more lifetime infections}
  \item{p0_2p}{numeric; probability of 0 infections at age A, and 2 or more lifetime infections}
  \item{p1_A}{numeric; probability of 1 infection at age A, and 1 or more lifetime infections}
  \item{p1_2p}{numeric; probability of 1 infection at age A, and 2 or more lifetime infections}
  \item{p1p_A}{numeric; probability of 1 or more infections at age A, and 1 or more lifetime infections}
  \item{p2p_A}{numeric; probability of 2 or more infections at age A, and 2 or more lifetime infections}
  \item{CA}{numeric; probability of converting from seronegative to seropositive between age A and A+1}
}
}
\description{
Compute the nPx(A), C(A) proportions from a population of life histories
}
\details{
computes the relevant nPx(A) and C(A): the probabilities of the various life trajectories, by age.
  See \href{https://arxiv.org/abs/1904.00214}{<arxiv:1904.00214>}, SI section II.A (Cost Benefit Equations: Definitions)
}
\examples{
require(denvax);
data(morrison2010) # has counts by age
fit <- with(morrison2010, serofit(sero=Seropositive, N=Number, age.min=Age))
m2010pop <- synthetic.pop(fit, runs = 10, popsize = 10) # small sample size for example run time
m2010lh <- nPxA(m2010pop)
m2010lh
with(m2010lh,
  plot(A, p0_2p*100, type="l",
    xlab="Age", ylab="\%", ylim = c(0, 100),
    main="Individuals w/ No Infections,\\nbut that will have 2"
  )
)

}
