% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{LikI.cmprsk.Cholesky}
\alias{LikI.cmprsk.Cholesky}
\title{Wrapper implementing likelihood function assuming independence between
competing risks and censoring using Cholesky factorization.}
\usage{
LikI.cmprsk.Cholesky(
  par.chol,
  data,
  eoi.indicator.names,
  admin,
  conf,
  cf,
  eps = 0.001
)
}
\arguments{
\item{par.chol}{Vector of all second step model parameters, consisting of the
regression parameters, Cholesky decomposition of the variance-covariance
matrix elements and transformation parameters.}

\item{data}{Data frame resulting from the 'uniformize.data.R' function.}

\item{eoi.indicator.names}{Vector of names of the censoring indicator columns
pertaining to events of interest. Events of interest will be modeled allowing
dependence between them, whereas all censoring events (corresponding to
indicator columns not listed in \code{eoi.indicator.names}) will be treated
as independent of every other event.}

\item{admin}{Boolean value indicating whether the data contains
administrative censoring.}

\item{conf}{Boolean value indicating whether the data contains confounding
and hence indicating the presence of Z and W.}

\item{cf}{"Control function" to be used. This can either be the (i) estimated
control function, (ii) the true control function, (iii) the instrumental
variable, or (iv) nothing (\code{cf = NULL}). Option (ii) is used when
comparing the two-step estimator to the oracle estimator, and option (iii) is
used to compare the two-step estimator with the naive estimator.}

\item{eps}{Minimum value for the diagonal elements in the covariance matrix.
Default is \code{eps = 0.001}.}
}
\value{
Log-likelihood evaluation for the second step in the estimation
procedure.
}
\description{
This function does the same as LikI.cmprsk (in fact, it even
calls said function), but it parametrizes the covariance matrix using its
Cholesky decomposition in order to guarantee positive definiteness. This
function is never used, might not work and could be deleted.
}
