% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_summary.R
\name{tidy_summary}
\alias{tidy_summary}
\alias{tidy_summary.summary.formula.reverse}
\alias{tidy_summary.summary.rms}
\title{tidy_summary}
\usage{
tidy_summary(x, ..., digits = 3L)

\method{tidy_summary}{summary.formula.reverse}(x, ..., digits = 3L)

\method{tidy_summary}{summary.rms}(x, ..., digits = 3L)
}
\arguments{
\item{x}{an object used to select a method, output of some summary
by \code{Hmisc}.}

\item{...}{further arguments passed to or from other methods}

\item{digits}{number of significant digits to use (default 3L).}
}
\value{
a [tibble][tibble::tibble-package]
}
\description{
Converts a \code{summary()} object produced by \code{Hmisc} or
by \code{rms} packages to a tidy data frame ready to be
`{pander}`ed (e.g. printed on a word document after
\code{knit}ting the source (with `{knitr}`).
}
\section{Methods (by class)}{
\itemize{
\item \code{summary.formula.reverse}: Tidies a summary reverse output from the
\code{\link[Hmisc]{summary.formula}} called with
\code{method = "reverse"}.

\item \code{summary.rms}: Convert the output of the
\code{\link[rms]{summary.rms}} into a data frame,
reporting only the Hazard Ratio with the .95 CI and the
incremental step (for continuous variables) reference
(for categorical variables) for which the Hazard is
referred to (i.e. without \eqn{\beta}s, Low, High, S.E.
and Type).
}}

\note{
to see the options you can pass to \code{...} for a custom
print, see the print section in \code{\link[Hmisc]{summary.formula}}.
}
\examples{
\donttest{
  library(Hmisc)
  my_summary <- summary(Species ~ ., data = iris, method = "reverse")
  tidy_summary(my_summary)
}
\donttest{
  library(rms)
  options(datadist = "dd")
  n <- 1000L
  set.seed(731L)
  age <- 50L + 12L * rnorm(n)
  sex <- factor(sample(c("Male", "Female"), n,
    rep = TRUE,
    prob = c(.6, .4)
  ))
  cens <- 15L * runif(n)
  h <- .02 * exp(.04 * (age - 50L) + .8 * (sex == "Female"))
  dt <- -log(runif(n)) / h
  e <- ifelse(dt <= cens, 1L, 0L)
  dt <- pmin(dt, cens)

  dd <- datadist(age, sex)

  S <- survival::Surv(dt, e)
  f <- rms::cph(S ~ age + sex)


  my_summary <- summary(f)
  tidy_summary(my_summary)
}
}
