\name{multistart}

\alias{multistart}

\alias{multistart,mix-method}
\alias{multistart,depmix-method}

\title{Methods to fit a (dep-)mix model using multiple sets of starting values}

\description{

	Fit a model using multiple sets of starting values.

}

\usage{

  \S4method{multistart}{mix}(object, nstart=10, initIters=10, ...)
  
}

\arguments{
	
	\item{object}{An object of class \code{mix} or \code{depmix}.}

	\item{nstart}{The number of sets of starting values that are used.}
	
	\item{initIters}{The number of EM iterations that each set of starting values is run.}
	
	\item{...}{Not used currently.}
}

\details{

	Starting values in the EM algorithm are generated by randomly assigning posterior state
	probabilities for each observation using a Dirichlet distribution. This is done \code{nstart}
	times. The EM algorithm is run \code{initIters} times for each set of starting values. The then
	best fitting model is then optimized until convergence. A warning is provided about the number
	of sets of starting values that are infeasible, e.g. due to non-finite log likelihood, if that 
	number is larger than zero. Note that the number of iterations reported in the final fitted 
	model does not include the initial number of iterations that EM was run for. 

}

\value{

	A fitted \code{(dep)mix} object. 
	
}

\examples{

data(speed)

# this example is from ?fit with fit now replaced by multistart and the 
# set.seed statement is left out
mod1 <- depmix(list(rt~1,corr~1),data=speed,transition=~Pacc,nstates=2,
	family=list(gaussian(),multinomial("identity")),ntimes=c(168,134,137))
set.seed(3)
fmod1 <- fit(mod1)
fmod2 <- multistart(mod1)
fmod1
fmod2

}
\author{Ingmar Visser & Maarten Speekenbrink}

\keyword{methods}
