% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peeking.r
\name{peeking}
\alias{peek}
\alias{peek.deque}
\alias{peek.queue}
\alias{peek.stack}
\alias{peekback}
\alias{peekback.deque}
\alias{peekback.queue}
\alias{peekback.stack}
\alias{peeking}
\title{peek/peekback}
\usage{
peek(x, n = 1L)

\method{peek}{deque}(x, n = 1L)

\method{peek}{queue}(x, n = 1L)

\method{peek}{stack}(x, n = 1L)

peekback(x, n = 1L)

\method{peekback}{deque}(x, n = 1L)

\method{peekback}{queue}(x, n = 1L)

\method{peekback}{stack}(x, n = 1L)
}
\arguments{
\item{x}{A queue, stack, or deque.}

\item{n}{The number of items to view.}
}
\value{
Returns \code{NULL}; sub-elements are only printed.
}
\description{
These methods are side-effect free. Note that unlike R's \code{head()} and
\code{tail()}, the sub-objects are not actually created. They are merely
printed to the terminal.
}
\details{
View items from the front (\code{peek()}) or back (\code{peekback()}) of a
queue, stack, or deque.
}
\examples{
\dontrun{
library(dequer)
s <- stack()
for (i in 1:3) push(s, i)

peek(s)
peekback(s)
peek(s, length(s))
}

}

