% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_tables.R
\name{cont_table}
\alias{cont_table}
\alias{mean.cont_table}
\alias{variance.cont_table}
\alias{stdev.cont_table}
\alias{covariance.cont_table}
\alias{correlation.cont_table}
\alias{joint}
\alias{conditional}
\alias{marginal}
\alias{var_decomp}
\alias{summary.var_decomp}
\alias{regline}
\alias{pre_print.cont_table}
\alias{format.cont_table}
\title{Contingency table}
\usage{
cont_table(
  data,
  y1,
  y2,
  weights = NULL,
  total = FALSE,
  xfirst1 = NULL,
  xlast1 = NULL,
  wlast1 = NULL,
  xfirst2 = NULL,
  xlast2 = NULL,
  wlast2 = NULL
)

\method{mean}{cont_table}(x, ..., drop = TRUE)

\method{variance}{cont_table}(x, ..., drop = TRUE)

\method{stdev}{cont_table}(x, ..., drop = TRUE)

\method{covariance}{cont_table}(x, drop = TRUE, ...)

\method{correlation}{cont_table}(x, drop = TRUE, ...)

joint(x)

conditional(x, y = NULL)

marginal(x, y = NULL)

var_decomp(x, y)

\method{summary}{var_decomp}(object, ...)

regline(formula, data)

\method{pre_print}{cont_table}(x)

\method{format}{cont_table}(x, ..., n = NULL, width = NULL, n_extra = NULL)
}
\arguments{
\item{data}{a tibble}

\item{y1}{a first factor}

\item{y2}{a second factor}

\item{weights}{a series containing the weights that should be used to
mimic the population}

\item{total}{if \code{TRUE} (the defaut values), a total is added to the
table}

\item{xfirst1}{the center of the first class for the first variable}

\item{xlast1}{the center of the last class for the first variable}

\item{wlast1}{the width of the last class for the first variable}

\item{xfirst2}{the center of the first class for the second variable}

\item{xlast2}{the center of the last class for the second variable}

\item{wlast2}{the width of the last class for the second variable}

\item{x, object}{a tibble containing the contingency table}

\item{...}{further arguments}

\item{drop}{if \code{TRUE}, the default, a numeric is returned,
otherwise the result is a tibble}

\item{y}{the series on which the operation should be computed}

\item{formula}{a formula which describe the model to estimate with
the \code{regline} function}

\item{n}{the number of lines to print}

\item{width}{the width of the table to print}

\item{n_extra}{extra n lines}
}
\value{
a tibble
}
\description{
A contingency table returns the counts of all the combinations of
the modalities of two factors in a table for which every modality
of the first factor is a row and every modality of the second
factor is a column. The \code{joint}, \code{marginal} and \code{conditional}
functions compute these three distribution from the contingency
table (by indicating on series for the last two). \code{mean},
\code{variance}, \code{stdev}, \code{covariance} and \code{correlation} methods are
provided. \code{regline} computes the regression line and \code{var_decomp}
the variance decomposition.
}
\examples{

cont_table(employment, education, sex)
cont_table(employment, education, sex, weights = weights)
cont_table(employment, education, sex) \%>\% conditional(sex)
cont_table(wages, wage, size)
cont_table(wages, wage, size) \%>\% joint
cont_table(wages, wage, size) \%>\% joint \%>\% mean
cont_table(wages, wage, size) \%>\% marginal(size)
cont_table(wages, wage, size) \%>\% conditional(size) \%>\% mean

}
\author{
Yves Croissant
}
