\name{exampleArrayDesignTable}
\docType{data}
\alias{exampleArrayDesignTable}
\title{Example output of ArrayDesignTable data}
\description{
\code{exampleArrayDesignTable}: Example data of \code{exampleArrayDesignTable} for a 
hypothetical dual-channel microarray experiment in which there are 100 strains  
(e.g. recombinant inbred lines) and 27 arrays available. Two environmental factors 
(temperature and cell type) are considered in this experiment. There are three 
levels for temperature (15, 24 and 29) and four levels for cell types (A,B,C,D).
This table tells how to pair samples into arrays.  
\preformatted{
data(exampleArrayDesignTable) 
exampleArrayDesignTable[1:5,]}
\tabular{lrr}{
            \tab Channel 1 \tab Channel 2 \cr 
array1      \tab Strain28    \tab Strain92 \cr    
array2      \tab Strain70    \tab Strain47 \cr    
array3      \tab Strain22    \tab Strain89 \cr    
array4      \tab Strain45    \tab Strain15 \cr    
array5      \tab Strain52    \tab Strain41 \cr
}
}
\usage{
data(exampleArrayDesignTable)
}
\format{ 
\code{exampleArrayDesignTable}: 27 arrays by two channels. 
}

\author{ 
 Yang Li <yang.li@rug.nl>, Gonzalo Vera <gonzalo.vera.rodriguez@gmail.com> \cr
  Rainer Breitling <r.breitling@rug.nl>, Ritsert Jansen <r.c.jansen@rug.nl> 
}

\examples{
  ##load the data
  data(exampleArrayDesignTable)
  
  ##view part of the the data
  exampleArrayDesignTable[1:5,]
}
\keyword{datasets}
