\name{ols}
\alias{ols}
\title{Ordinary Least Squares Regression}
\usage{
ols(
  formula,
  data = list(),
  na.action = NULL,
  contrasts = NULL,
  details = FALSE,
  ...
)
}
\arguments{
\item{formula}{model formula.}

\item{data}{name of data frame of variables in \code{formula}.}

\item{na.action}{function which indicates what should happen when the data contain NAs.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \code{\link[stats]{model.matrix.default}}.}

\item{details}{logical value indicating whether details should be printed out by default.}

\item{...}{other arguments that \code{lm.fit()} supports.}
}
\value{
A list object including:
\tabular{ll}{
\code{coefficients/coef} \tab estimated parameters of the model.\cr
\code{residuals/resid} \tab residuals of the estimation.\cr
\code{effects} \tab n vector of orthogonal single-df effects. The first rank of them correspond to non-aliased coefficients, and are named accordingly.\cr
\code{fitted.values} \tab fitted values of the regression line.\cr
\code{df.residual/df} \tab degrees of freedom in the model (number of observations minus rank).\cr
\code{se} \tab vector of standard errors of the parameter estimators.\cr
\code{t.value} \tab vector of t-values of single parameter significance tests.\cr
\code{p.value} \tab vector of p-values of single parameter significance tests.\cr
\code{data/model} \tab matrix of the variables' data used.\cr
\code{response} \tab the endogenous (response) variable.\cr
\code{model.matrix} \tab the model (design) matrix.\cr
\code{ssr} \tab sum of squared residuals.\cr
\code{sig.squ} \tab estimated error variance (sigma squared).\cr
\code{vcov} \tab the variance-covariance matrix of the model's estimators.\cr
\code{r.squ} \tab coefficient of determination (R squared).\cr
\code{adj.r.squ} \tab adjusted coefficient of determination (adj. R squared).\cr
\code{nobs} \tab number of observations.\cr
\code{ncoef/rank} \tab integer, giving the rank of the model (number of coefficients estimated).\cr
\code{has.const} \tab logical value indicating whether model has constant parameter.\cr
\code{f.val} \tab F-value for simultaneous significance of all slope parameters.\cr
\code{f.pval} \tab p-value for simultaneous significance of all slope parameters.\cr
\code{modform} \tab the model's regression R-formula.\cr
\code{call} \tab the function call by which the regression was calculated (including \code{modform}).\cr
}
}
\description{
Estimates linear models using ordinary least squares estimation. Generated objects should be compatible with commands expecting objects generated by \code{lm()}. The object returned by this command can be plotted using the \code{plot()} function.
}
\details{
Let X be a model object generated by \code{ols()} then \code{plot(X, ...)} accepts the following arguments:
\tabular{ll}{
\code{pred.int = FALSE} \tab should prediction intervals be added to plot?\cr
\code{conf.int = FALSE} \tab should confidence intervals be added to plot?\cr
\code{residuals = FALSE} \tab should residuals be added to plot?\cr
\code{center = FALSE} \tab should mean values of both variables be added to plot?\cr
}
}
\examples{
## Minimal simple regression model
check <- c(10,30,50)
tip <- c(2,3,7)
tip.est <- ols(tip ~ check)

## Equivalent estimation using data argument
tip.est <- ols(y ~ x, data = data.tip)

## Show estimation results
tip.est

## Show details
print(tip.est, details = TRUE)

## Plot scatter and regression line
plot(tip.est)

## Plot confidence (dark) and prediction bands (light), residuals and two center lines
plot(tip.est, pred.int = TRUE, conf.int = TRUE, residuals = TRUE, center = TRUE)

## Multiple regression model
fert.est <- ols(barley ~ phos + nit, data = log(data.fertilizer), details = TRUE)
fert.est

}
\concept{linear model}
\concept{ordinary least squares}
\concept{regression}
