% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-win.R
\name{check_win}
\alias{check_win}
\alias{check_win_devel}
\alias{check_win_release}
\alias{check_win_oldrelease}
\title{Build windows binary package.}
\usage{
check_win_devel(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)

check_win_release(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)

check_win_oldrelease(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{args}{An optional character vector of additional command
line arguments to be passed to \code{R CMD build} if \code{binary = FALSE},
or \code{R CMD install} if \code{binary = TRUE}.}

\item{manual}{For source packages: if \code{FALSE}, don't build PDF
vignettes (\code{--no-build-vignettes}) or manual (\code{--no-manual}).}

\item{email}{An alternative email to use, default \code{NULL} uses the package
Maintainer's email.}

\item{quiet}{If \code{TRUE}, suppresses output.}

\item{...}{Additional arguments passed to \code{\link[pkgbuild:build]{pkgbuild::build()}}.}
}
\description{
This function works by bundling source package, and then uploading to
\url{https://win-builder.r-project.org/}.  Once building is complete you'll
receive a link to the built package in the email address listed in the
maintainer field.  It usually takes around 30 minutes. As a side effect,
win-build also runs \verb{R CMD check} on the package, so \code{check_win}
is also useful to check that your package is ok on windows.
}
\section{Functions}{
\itemize{
\item \code{check_win_devel}: Check package on the development version of R.

\item \code{check_win_release}: Check package on the release version of R.

\item \code{check_win_oldrelease}: Check package on the previous major release version of R.
}}

\seealso{
Other build functions: 
\code{\link{check_rhub}()}
}
\concept{build functions}
