% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_tests}
\alias{add_tests}
\title{Add test data for an existing booklet}
\usage{
add_tests(db, x, booklet_id)
}
\arguments{
\item{db}{A handle to the database, i.e. the output of \code{start_new_project}
or \code{open_project}}

\item{x}{A data frame containing the responses and, possibly, some additional
person characteristics. See details.}

\item{booklet_id}{A (short) string identifying the test form (booklet)}
}
\value{
A list of: \item{items}{The names of the columns in \code{x} that were
treated as items}
\item{covariates}{The names of the columns in \code{x} that were
treated as person covariates}
\item{not_listed}{A data frame of all responses that will be treated as missing}
}
\description{
Adds item response data for a test form (a.k.a. booklet) that
already exists in the data base. This function has been added 
as a workaround by user request -- we do not necessarily approve.
}
\author{
Ivailo Partchev
}

