% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_model.R
\name{plot.rim}
\alias{plot.rim}
\title{A plot method for the interaction model}
\usage{
\method{plot}{rim}(x, items = NULL, summate = TRUE, overlay = FALSE,
  nc = 1, nr = 1, curtains = 10, show.observed = FALSE, ...)
}
\arguments{
\item{x}{An object produced by function \code{fit_inter}}

\item{items}{The items to plot (item_id's). If NULL, all items will be plotted}

\item{summate}{If FALSE, regressions for polytomous items will be shown for each
response option separately; default is TRUE.}

\item{overlay}{If TRUE and more than one item is specified, there will be two plots,
one for the Rasch model and the other for the interaction model, with all items
overlayed; otherwise, one plot for each item with the two models overlayed. Ignored
if summate is FALSE. Default is FALSE}

\item{nc}{An integer between 1 and 3. Number of columns when putting mutiple plots
on the same page. Default is 1. May be ignored or adjusted if it does not make sense.}

\item{nr}{An integer between 1 and 3. Number of rows when putting mutiple plots
on the same page. Default is 1. May be ignored or adjusted if it does not make sense.}

\item{curtains}{100*the tail probability of the sum scores to be shaded. Default is 10.
Set to 0 to have no curtains shown at all.}

\item{show.observed}{If TRUE, the observed proportion correct at each sum score
will be shown as dots. Default is FALSE.}

\item{...}{Any additional plotting parameters.}
}
\description{
Plot the item-total regressions fit by the interaction (or Rasch) model
}
\details{
Customisation of title and subtitle can be done by using the arguments main and sub.
These arguments can contain references to the variables item_id (if overlay=FALSE) or model (if overlay=TRUE)
by prefixing them with a dollar sign, e.g. plot(m, main='item: $item_id')
}
