% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausible_scores.R
\name{plausible_scores}
\alias{plausible_scores}
\title{Generate plausible testscores}
\usage{
plausible_scores(dataSrc, parms = NULL, predicate = NULL,
  items = NULL, covariates = NULL, keep.observed = TRUE, nPS = 1,
  merge_within_persons = FALSE)
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{parms}{An object returned by function \code{fit_enorm} and containing
parameter estimates. If parms is given the function provides plausible scores conditional on the 
item parameters. These are considered known. If \code{parms} is \code{NULL}, Bayesian parameters are calculated from the datasrc}

\item{predicate}{an expression to filter data. If missing, the function will use 
all data in dataSrc}

\item{items}{vector of item_id's, this specifies the itemset to generate the testscores for. If \code{items} is \code{NULL} 
all items occurring in \code{dataSrc} are used.}

\item{covariates}{name or a vector of names of the variables to group the population, used to update the prior.
A covariate must be a discrete person covariate (e.g. not a float) that indicates nominal categories, e.g. gender or school
If dataSrc is a data.frame, it must contain the covariate.}

\item{keep.observed}{If responses to one or more of the items have been observed,
the user can choose to keep these observations or generate new ones.}

\item{nPS}{Number of plausible testscores to generate per person.}

\item{merge_within_persons}{If a person took multiple booklets, this indicates
whether plausible scores are generated per person (TRUE) or per booklet (FALSE)}
}
\value{
A data.frame with columns booklet_id, person_id, booklet_score and nPS plausible scores
named PS1...PSn.
}
\description{
Generate plausible i.e., posterior predictive sumscores on a set of items. 
A typical use of this function is to generate plausible scores on
a complete item bank when data is collected using an incomplete design
}
