% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_summary_coverage.r
\name{data_summary_coverage}
\alias{data_summary_coverage}
\title{Obtain the non-zero coverage for both two conditions and the condition-based difference}
\usage{
data_summary_coverage(dataList.CI, save_res = FALSE, output_dir = NULL)
}
\arguments{
\item{dataList.CI}{list, a list of data matrices which include the confidence interval estimates obtained from linear mixed models.}

\item{save_res}{logical, whether to save the result or not, if true, an output directory should be provided}

\item{output_dir}{character, directory for output files}
}
\value{
A list which contains 9 data frames: 
 \describe{
  \item{coverage.zero.cond.diff}{Percentage of estimates for condition difference that are within 95\% confidence interval with a center of zero.}
  \item{coverage.zero.cond.1}{Percentage of estimates for condition 1 that are within 95\% confidence interval with a center of zero.}
  \item{coverage.zero.cond.2}{Percentage of estimates for condition 2 that are below 95\% confidence interval with a center of zero.}
  \item{coverage.below.zero.cond.2}{Percentage of estimates for condition 2 that are below 95\% confidence interval with a center of zero.}
  \item{coverage.below.zero.cond.diff}{Percentage of estimates for condition difference that are below 95\% confidence interval with a center of zero.}
  \item{coverage.below.zero.cond.1}{Percentage of estimates for condition 1 that are below 95\% confidence interval with a center of zero.}
  \item{coverage.above.zero.cond.diff}{Percentage of estimates for condition difference that are above 95\% confidence interval with a center of zero.}
  \item{coverage.above.zero.cond.1}{Percentage of estimates for condition 1 that are above 95\% confidence interval with a center of zero.}
  \item{coverage.above.zero.cond.2}{Percentage of estimates for condition 1 that are above 95\% confidence interval with a center of zero.}
}
}
\description{
Summarize the data from dynamic functional connectivity linear mixed modeling.
}
\examples{
# Summarize the output of linear mixed effect model for dynamic functional connectivity
data(DynModel_results)
data_summary_coverage(DynModel_results$est_CI)
\dontshow{
rm(list = c("DynModel_results"))
gc()
}
}
\concept{summary}
