% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfidx.R
\name{methods.dfidx}
\alias{methods.dfidx}
\alias{[.dfidx}
\alias{as.data.frame.dfidx}
\alias{print.dfidx}
\alias{head.dfidx}
\alias{[[.dfidx}
\alias{$.dfidx}
\alias{$<-.dfidx}
\alias{[[<-.dfidx}
\alias{print.xseries}
\alias{print.idx}
\alias{mean.dfidx}
\title{Methods for dfidx}
\usage{
\method{[}{dfidx}(x, i, j, drop = TRUE)

\method{as.data.frame}{dfidx}(x, row.names = NULL, optional = FALSE, ...)

\method{print}{dfidx}(x, ..., n = 10L)

\method{head}{dfidx}(x, n = 10L, ...)

\method{[[}{dfidx}(x, y)

\method{$}{dfidx}(x, y)

\method{$}{dfidx}(object, y) <- value

\method{[[}{dfidx}(object, y) <- value

\method{print}{xseries}(x, ..., n = 10L)

\method{print}{idx}(x, ..., n = 10L)

\method{mean}{dfidx}(x, ...)
}
\arguments{
\item{x, object}{a \code{dfidx} object}

\item{i}{the row index}

\item{j}{the column index}

\item{drop}{if \code{TRUE} a vector is returned if the result is a one
column \code{data.frame}}

\item{row.names, optional}{arguments of the generic \code{as.data.frame}
method, not used}

\item{...}{further arguments}

\item{n}{the number of rows for the print method}

\item{y}{the name or the position of the series one wishes to
extract}

\item{value}{the value for the replacement method}
}
\value{
\code{as.data.frame} and \code{mean} return a \code{data.frame}, \code{[[} and
\code{$} a vector, \code{[} either a \code{dfidx} or a vector, \verb{$<-}
and \verb{[[<-} modify the values of an existing coumn or create a
new column of a \code{dfidx} object, \code{print} is called for its side
effect
}
\description{
A \code{dfidx} is a \code{data.frame} with a "sticky" data.frame column
which contains the indexes. Specific methods of functions that
extract lines and/or columns of a \code{data.frame} are provided.
}
\examples{
data("TravelMode", package = "AER")
TM <- dfidx(TravelMode)
# extract a series (returns as a xseries object)
TM$wait
# or
TM[["wait"]]
# extract a subset of series (returns as a dfidx object)
TM[c("wait", "income")]
# extract a subset of rows and columns
TM[TM$income > 30, c("wait", "income")]
# dfidx, idx and xseries have print methods as (like tibbles), a n
# argument
print(TM, n = 3)
print(idx(TM), n = 3)
print(TM$income, n = 3)
# a dfidx object can be coerced to a data.frame
head(as.data.frame(TM))

}
\author{
Yves Croissant
}
