% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict}
\alias{predict}
\alias{predict.dgp}
\alias{predict.lgp}
\alias{predict.gp}
\title{Predictions from GP, DGP, or linked (D)GP emulators}
\usage{
\method{predict}{dgp}(
  object,
  x,
  method = "mean_var",
  full_layer = FALSE,
  sample_size = 50,
  cores = 1,
  chunks = NULL,
  threading = FALSE,
  ...
)

\method{predict}{lgp}(
  object,
  x,
  method = "mean_var",
  full_layer = FALSE,
  sample_size = 50,
  cores = 1,
  chunks = NULL,
  threading = FALSE,
  ...
)

\method{predict}{gp}(
  object,
  x,
  method = "mean_var",
  sample_size = 50,
  cores = 1,
  chunks = NULL,
  ...
)
}
\arguments{
\item{object}{an instance of the \code{gp}, \code{dgp}, or \code{lgp} class.}

\item{x}{the testing input data:
\itemize{
\item if \code{object} is an instance of the \code{gp} or \code{dgp} class, \code{x} is a matrix where each row is an input testing data point and each column is an input dimension.
\item if \code{object} is an instance of the \code{lgp} class, \code{x} can be a matrix or a list:
\itemize{
\item if \code{x} is a matrix, it is the global testing input data that feed into the emulators in the first layer of a system.
The rows of \code{x} represent different input data points and the columns represent input dimensions across all emulators in
the first layer of the system. In this case, it is assumed that the only global input to the system is the input to the
emulators in the first layer and there is no global input to emulators in other layers.
\item if \code{x} is a list, it should have \emph{L} (the number of layers in an emulator system) elements. The first element
is a matrix that represents the global testing input data that feed into the emulators in the first layer of the system. The
remaining \emph{L-1} elements are \emph{L-1} sub-lists, each of which contains a number (the same number of emulators in
the corresponding layer) of matrices (rows being testing input data points and columns being input dimensions) that represent the
global testing input data to the emulators in the corresponding layer. The matrices must be placed in the sub-lists based on how
their corresponding emulators are placed in \code{struc} argument of \code{\link[=lgp]{lgp()}}. If there is no global input data to a certain emulator,
set \code{NULL} in the corresponding sub-list of \code{x}.
}
}}

\item{method}{the prediction approach: mean-variance (\code{"mean_var"}) or sampling (\code{"sampling"}) approach. Defaults to \code{"mean_var"}.}

\item{full_layer}{a bool indicating whether to output the predictions of all layers. Defaults to \code{FALSE}. Only used when \code{object} is a DGP and linked (D)GP emulator.}

\item{sample_size}{the number of samples to draw for each given imputation if \code{method = "sampling"}. Defaults to \code{50}.}

\item{cores}{the number of cores/workers to be used. If set to \code{NULL},
the number of cores is set to \verb{(max physical cores available - 1)}. Defaults to \code{1}.}

\item{chunks}{the number of chunks that the testing input matrix \code{x} will be divided into for multi-cores to work on.
Only used when \code{cores} is not \code{1}. If not specified (i.e., \code{chunks = NULL}), the number of chunks is set to the value of \code{cores}.
Defaults to \code{NULL}.}

\item{threading}{a bool indicating whether to use the multi-threading to accelerate the predictions of DGP or linked (D)GP emulators. Turn this option on
when you use the Matérn-2.5 kernel and have a moderately large number of training data points as in such a case you could gain faster predictions. Defaults to \code{FALSE}.}

\item{...}{N/A.}
}
\value{
\itemize{
\item If \code{object} is an instance of the \code{gp} class:
\enumerate{
\item if \code{method = "mean_var"}: an updated \code{object} is returned with an additional slot called \code{results} that contains two matrices named \code{mean}
for the predictive means and \code{var} for the predictive variances. Each matrix has only one column with its rows
corresponding to testing positions (i.e., rows of \code{x}).
\item if \code{method = "sampling"}: an updated \code{object} is returned with an additional slot called \code{results} that contains a matrix whose rows correspond
to testing positions and columns correspond to \code{sample_size} number of samples drawn from the predictive distribution of GP.
}
\item If \code{object} is an instance of the \code{dgp} class:
\enumerate{
\item if \code{method = "mean_var"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains two
matrices named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each matrix has its rows corresponding to testing
positions and columns corresponding to DGP global output dimensions (i.e., the number of GP/likelihood nodes in the final layer).
\item if \code{method = "mean_var"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains two
sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list contains \emph{L} (i.e., the number of layers)
matrices named \verb{layer1, layer2,..., layerL}. Each matrix has its rows corresponding to testing positions and columns corresponding to
output dimensions (i.e., the number of GP/likelihood nodes from the associated layer).
\item if \code{method = "sampling"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains \emph{D} (i.e., the number
of GP/likelihood nodes in the final layer) matrices named \verb{output1, output2,..., outputD}. Each matrix has its rows corresponding to testing positions and
columns corresponding to samples of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=dgp]{dgp()}}.
\item if \code{method = "sampling"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains \emph{L} (i.e., the number
of layers) sub-lists named \verb{layer1, layer2,..., layerL}. Each sub-list represents samples drawn from the GP/likelihood nodes in the corresponding layer,
and contains \emph{D} (i.e., the number of GP/likelihood nodes in the corresponding layer) matrices named \verb{output1, output2,..., outputD}. Each matrix gives samples
of the output from one of \emph{D} GP/likelihood nodes, and has its rows corresponding to testing positions and columns corresponding to samples
of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=dgp]{dgp()}}.
}
\item If \code{object} is an instance of the \code{lgp} class:
\enumerate{
\item if \code{method = "mean_var"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that
contains two sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list
contains \emph{M} number (same number of emulators in the final layer of the system) of matrices named \verb{emulator1, emulator2,..., emulatorM}.
Each matrix has its rows corresponding to global testing positions and columns corresponding to output dimensions of the associated emulator
in the final layer.
\item if \code{method = "mean_var"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
two sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list contains \emph{L}
(i.e., the number of layers in the emulated system) components named \verb{layer1, layer2,..., layerL}. Each component represents a layer
and contains \emph{M} number (same number of emulators in the corresponding layer of the system) of matrices named \verb{emulator1, emulator2,..., emulatorM}.
Each matrix has its rows corresponding to global testing positions and columns corresponding to output dimensions of the associated
GP/DGP emulator in the corresponding layer.
\item if \code{method = "sampling"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
\emph{M} number (same number of emulators in the final layer of the system) of sub-lists named \verb{emulator1, emulator2,..., emulatorM}. Each
sub-list corresponds to an emulator in the final layer, and contains \emph{D} matrices, named \verb{output1, output2,..., outputD}, that correspond to the output
dimensions of the GP/DGP emulator. Each matrix has its rows corresponding to testing positions and columns corresponding to samples
of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=lgp]{lgp()}}.
\item if \code{method = "sampling"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
\emph{L} (i.e., the number of layers of the emulated system) sub-lists named \verb{layer1, layer2,..., layerL}. Each sub-list represents a layer
and contains \emph{M} number (same number of emulators in the corresponding layer of the system) of components named \verb{emulator1, emulator2,..., emulatorM}.
Each component corresponds to an emulator in the associated layer, and contains \emph{D} matrices, named \verb{output1, output2,..., outputD}, that correspond to
the output dimensions of the GP/DGP emulator. Each matrix has its rows corresponding to testing positions and columns corresponding to
samples of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=lgp]{lgp()}}.
}
}
}
\description{
This function implements single-core or multi-core predictions (with or without multi-threading)
from GP, DGP, or linked (D)GP emulators.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
Any R vector detected in \code{x} will be treated as a column vector and automatically converted into a single-column R matrix.
Thus, if \code{x} is a single testing data point with multiple dimensions, it must be given as a matrix.
}
\examples{
\dontrun{

# See gp(), dgp(), or lgp() for an example.
}
}
