% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/minus_block_matrix.R
\name{minus_block_matrix}
\alias{minus_block_matrix}
\title{Minus Block Matrix}
\usage{
minus_block_matrix(x, steps = NULL, size = NULL, replacement = 0)
}
\arguments{
\item{x}{a square matrix where the dimensions are integer multiples of size or integer dividors of steps}

\item{steps}{the required number of steps (block matrices) across the diagonal}

\item{size}{the width or height of the matrix being dropped over the diagonal of matrix x}

\item{replacement}{value to be inserted on the diagonal, by default this is zero (0).}
}
\description{
Minus Block Matrix
}
\details{
Either steps or size is expected to be provided.
}
\examples{
# create a square matrix
m <- matrix(1:64, nrow=8)

# select a block matrix with two steps
minus_block_matrix(m, steps=2)

# select a block matrix with four steps
minus_block_matrix(m, steps=4)
}

