% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{dialr-type}
\alias{dialr-type}
\alias{get_type}
\alias{get_supported_types}
\alias{get_types_for_region}
\title{Phone number type}
\usage{
get_type(x)

get_supported_types()

get_types_for_region(x)
}
\arguments{
\item{x}{A \link{phone} vector, or a character vector of \link[=dialr-region]{ISO country codes}.}
}
\value{
A character vector of phone types.

\code{get_types_for_region()} returns a list of character vectors for each
provided country code.
}
\description{
In addition to validity, libphonenumber can identify phone number type - it
is able to distinguish Fixed-line, Mobile, Toll-free, Premium Rate, Shared
Cost, VoIP, Personal Numbers, UAN, Pager, and Voicemail (whenever feasible).

\code{get_type(x)} returns the phone number type for each element of a \link{phone}
vector.

Valid phone number types differ by region. \code{get_types_for_region(x)} returns
a list of character vectors of valid types for each provided
\link[=dialr-region]{ISO country code}. Use \code{get_supported_types()} to see a full
list of supported types.
}
\section{libphonenumber reference}{


\code{get_type()}: \code{PhoneNumberUtil.getNumberType()}

\code{get_supported_types()}: \code{PhoneNumberUtil.PhoneNumberType}

\code{get_types_for_region()}: \code{PhoneNumberUtil.getSupportedTypesForRegion()}
}

\examples{
  # Get phone types for a phone vector
  x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")
  get_type(x)
  
  # All supported phone types
  get_supported_types()
  
  # Get supported types for specified regions
  get_types_for_region("AU")
  get_types_for_region(c("GB", "US"))
  get_types_for_region(get_supported_regions())[1:5]
  
}
\seealso{
Other phone functions: \code{\link{dialr-phone}},
  \code{\link{dialr-region}}, \code{\link{dialr-valid}},
  \code{\link{dialr}}
}
\concept{phone functions}
