% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{new-param}
\alias{new-param}
\alias{new_quant_param}
\alias{new_qual_param}
\title{Tools for creating new parameter objects}
\usage{
new_quant_param(
  type = c("double", "integer"),
  range,
  inclusive,
  default = unknown(),
  trans = NULL,
  values = NULL,
  label = NULL,
  finalize = NULL
)

new_qual_param(
  type = c("character", "logical"),
  values,
  default = unknown(),
  label = NULL,
  finalize = NULL
)
}
\arguments{
\item{type}{A single character value. For quantitative parameters, valid
choices are \code{"double"} and \code{"integer"} while for qualitative factors they are
\code{"character"} and \code{"logical"}.}

\item{range}{A two-element vector with the smallest or largest possible
values, respectively. If these cannot be set when the parameter is defined,
the \code{unknown()} function can be used. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{inclusive}{A two-element logical vector for whether the range
values should be inclusive or exclusive.}

\item{default}{A single value the same class as \code{type} for the default
parameter value. \code{unknown()} can also be used here.}

\item{trans}{A \code{trans} object from the \pkg{scales} package, such as
\code{\link[scales:log10_trans]{scales::log10_trans()}} or \code{\link[scales:reciprocal_trans]{scales::reciprocal_trans()}}. Create custom
transforms with \code{\link[scales:trans_new]{scales::trans_new()}}.}

\item{values}{A vector of possible values that is required when \code{type} is
\code{"character"} or \code{"logical"} but optional otherwise. For quantitative
parameters, these override the \code{range} when generating sequences if set.}

\item{label}{An optional named character string that can be used for
printing and plotting. The name should match the object name (e.g.
\code{"mtry"}, \code{"neighbors"}, etc.)}

\item{finalize}{A function that can be used to set the data-specific
values of a parameter (such as the \code{range}).}
}
\value{
An object of class \code{"param"} with the primary class being either
\code{"quant_param"} or \code{"qual_param"}. The \code{range} element of the object
is always converted to a list with elements \code{"lower"} and \code{"upper"}.
}
\description{
These functions are used to construct new parameter objects. Generally,
these functions are called from higher level parameter generating functions
like \code{\link[=mtry]{mtry()}}.
}
\examples{
# Create a function that generates a quantitative parameter
# corresponding to the number of subgroups.
num_subgroups <- function(range = c(1L, 20L), trans = NULL) {
  new_quant_param(
    type = "integer",
    range = range,
    inclusive = c(TRUE, TRUE),
    trans = trans,
    label = c(num_subgroups = "# Subgroups"),
    finalize = NULL
  )
}

num_subgroups()

num_subgroups(range = c(3L, 5L))

# Custom parameters instantly have access
# to sequence generating functions
value_seq(num_subgroups(), 5)

}
