% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{update.parameters}
\alias{update.parameters}
\title{Update a single parameter in a parameter set}
\usage{
\method{update}{parameters}(object, ...)
}
\arguments{
\item{object}{A parameter set.}

\item{...}{One or more unquoted named values separated by commas. The names
should correspond to the \code{id} values in the parameter set. The values should
be parameter objects or \code{NA} values.}
}
\value{
The modified parameter set.
}
\description{
Update a single parameter in a parameter set
}
\examples{
params <- list(lambda = penalty(), alpha = mixture(), `rand forest` = mtry())
pset <- parameters(params)
pset

update(pset, `rand forest` = finalize(mtry(), iris), alpha = mixture(c(.1, .2)))
}
