% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_bart.R
\name{bart-param}
\alias{bart-param}
\alias{prior_terminal_node_coef}
\alias{prior_terminal_node_expo}
\alias{prior_outcome_range}
\title{Parameters for BART models
These parameters are used for constructing Bayesian adaptive regression tree
(BART) models.}
\usage{
prior_terminal_node_coef(range = c(0, 1), trans = NULL)

prior_terminal_node_expo(range = c(0, 3), trans = NULL)

prior_outcome_range(range = c(0, 5), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Parameters for BART models
These parameters are used for constructing Bayesian adaptive regression tree
(BART) models.
}
\details{
These parameters are often used with Bayesian adaptive regression trees (BART)
via \code{parsnip::bart()}.
}
