% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_combine.R
\name{consensus_combine}
\alias{consensus_combine}
\title{Combine algorithms}
\usage{
consensus_combine(..., element = c("matrix", "class"))
}
\arguments{
\item{...}{any number of objects outputted from
\code{\link{consensus_cluster}}}

\item{element}{either "matrix" or "class" to extract the consensus matrix or
consensus class, respectively.}
}
\value{
\code{consensus_combine} returns either a list of all consensus
  matrices or a data frame showing all the consensus classes
}
\description{
Combines results for multiple objects from \code{consensus_cluster()} and
outputs either the consensus matrices or consensus classes for all
algorithms.
}
\details{
This function is useful for collecting summaries because the original results
from \code{consensus_cluster} were combined to a single object. For example,
setting \code{element = "class"} returns a matrix of consensus cluster
assignments, which can be visualized as a consensus matrix heatmap.
}
\examples{
# Consensus clustering for multiple algorithms
set.seed(911)
x <- matrix(rnorm(500), ncol = 10)
CC1 <- consensus_cluster(x, nk = 3:4, reps = 10, algorithms = "ap",
progress = FALSE)
CC2 <- consensus_cluster(x, nk = 3:4, reps = 10, algorithms = "km",
progress = FALSE)

# Combine and return either matrices or classes
y1 <- consensus_combine(CC1, CC2, element = "matrix")
str(y1)
y2 <- consensus_combine(CC1, CC2, element = "class")
str(y2)
}
\author{
Derek Chiu
}
