% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{relabel_class}
\alias{relabel_class}
\title{Relabel classes to a standard}
\usage{
relabel_class(pred.cl, ref.cl)
}
\arguments{
\item{pred.cl}{vector of predicted cluster assignments}

\item{ref.cl}{vector of reference labels to match to}
}
\value{
A vector of relabeled cluster assignments
}
\description{
Relabel clustering categories to match to a standard by minimizing the
Frobenius norm between the two labels.
}
\examples{
set.seed(2)
pred <- sample(1:4, 100, replace = TRUE)
true <- sample(1:4, 100, replace = TRUE)
relabel_class(pred, true)
}
\author{
Aline Talhouk
}
