% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{set_debris_test_set}
\alias{set_debris_test_set}
\title{Set debris and test droplets}
\usage{
set_debris_test_set(x, top_n = 10000, min_counts = 100,
  min_genes = 100, fix_debris = NULL, verbose = FALSE)
}
\arguments{
\item{x}{An SCE object.}

\item{top_n}{A numeric value giving the total number of test droplets 
and take the counts of the \code{top_n} ranked droplet. Set to \code{NULL} 
to disable and set all droplets above \code{min_counts} and 
\code{min_genes} to the test set.}

\item{min_counts}{A numeric value that specifies the minimum 
total read/UMI counts a test droplet can have.}

\item{min_genes}{A numeric value that specifies the minimum 
total genes detected a test droplet can have.}

\item{fix_debris}{A character vector of droplet IDs that will be assigned 
to the debris set, regardless of its total counts or genes detected.}

\item{verbose}{verbosity}
}
\value{
An SCE object.
}
\description{
Specifies the droplets that are in the test set and debris set. 
The test set consists of droplets that will be classified by DIEM, 
the labels of which are allowed to change during the EM. 
The debris set consists of droplets with labels fixed to the 
debris group during the EM.
}
\details{
\code{min_counts} and \code{min_genes} specify the lower limit 
that droplets in the test set must have. In addition, 
the parameter \code{top_n} specifies that at most the top \code{top_n} 
should be included in the test set. The default is 10,000 
in accordance with the typical maximum number of droplets 
generated during a single-cell experiment, but should be changed 
accordingly.
If the read/UMI count of the \code{top_n} count-ranked droplet is greater 
than \code{min_counts}, then the \code{min_counts} is 
increased to this limit. The \code{fix_debris} parameter allows 
additional flexibility in specifying those droplets that are 
included in the debris set. For example, it may be useful to 
set droplets above a pre-determined MT% threshold as debris, 
regardless of the total number of read/UMI counts present.
}
