% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrNLR.R
\name{constrNLR}
\alias{constrNLR}
\title{Constraints for Non-Linear Regression Model}
\usage{
constrNLR(model, type = "both")
}
\arguments{
\item{model}{character: generalized logistic regression model to be fitted. See \strong{Details}.}

\item{type}{character: type of DIF to be tested (either "both" (default), "udif", or "nudif"). See \strong{Details}.}
}
\value{
A matrix with 4 rows and 8 columns. First two rows represent lower and
upper constraints for null model. Last two rows represent lower and upper constraints
for alternative model. First four columns represent parameters of 4PL generalized
logistic regression model (a, b, c, d) for reference group. Last four columns represent
differences in parameters between reference and focal group (aDif, bDif, cDif, dDif).
}
\description{
Specifies the constraints for Non-Linear Regression model.
}
\details{
Function specifies constraints for 4PL generalized logistic regression model with
respect to \code{model} choice and \code{type} of DIF to be tested.

The options of \code{model} are as follows: \code{Rasch} for one-parameter logistic model with
discrimination parameter fixed on value 1 for both groups, \code{1PL} for one-parameter logistic
model with discrimination parameter fixed for both groups, \code{2PL} for logistic regression model,
\code{3PLcg} for three-parameter logistic regression model with fixed guessing for both groups,
\code{3PLdg} for three-parameter logistic regression model with fixed inattention for both groups, or
\code{4PLcgdg} for four-parameter logistic regression model with fixed guessing and inattention
parameter for both groups.

The \code{type} corresponds to type of DIF to be tested. Possible values are \code{"both"} to
detect any DIF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DIF or
\code{"nudif"} to detect only non-uniform DIF.
return(rbind(lowerM0, upperM0, lowerM1, upperM1))
}
\examples{
\dontrun{
# 3PL model with the same guessing for both groups
# to test both types of DIF
constrNLR(model = "3PLcg", type = "both")

# 4PL model with the same guessing and inattention
# to test uniform DIF
constrNLR(model = "4PLcgdg", type = "udif")

# 2PL model to test non-uniform DIF
constrNLR(model = "2PL", type = "nudif")
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
