% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\docType{methods}
\name{diffFile}
\alias{diffFile}
\alias{diffFile,ANY-method}
\title{Diff Files}
\usage{
diffFile(target, current, ...)

\S4method{diffFile}{ANY}(target, current, mode = gdo("mode"),
  context = gdo("context"), format = gdo("format"),
  brightness = gdo("brightness"), color.mode = gdo("color.mode"),
  word.diff = gdo("word.diff"), pager = gdo("pager"),
  guides = gdo("guides"), trim = gdo("trim"), rds = gdo("rds"),
  unwrap.atomic = gdo("unwrap.atomic"), max.diffs = gdo("max.diffs"),
  disp.width = gdo("disp.width"),
  ignore.white.space = gdo("ignore.white.space"),
  convert.hz.white.space = gdo("convert.hz.white.space"),
  tab.stops = gdo("tab.stops"), line.limit = gdo("line.limit"),
  hunk.limit = gdo("hunk.limit"), align = gdo("align"),
  style = gdo("style"), palette.of.styles = gdo("palette"),
  frame = par_frame(), interactive = gdo("interactive"),
  term.colors = gdo("term.colors"), tar.banner = NULL, cur.banner = NULL,
  extra = list())
}
\arguments{
\item{target}{character(1L) or file connection with read capability; if
character should point to a text file}

\item{current}{like \code{target}}

\item{...}{unused, for compatibility of methods with generics}

\item{mode}{character(1L), one of:
\itemize{
  \item \dQuote{unified}: diff mode used by \code{git diff}
  \item \dQuote{sidebyside}: line up the differences side by side
  \item \dQuote{context}: show the target and current hunks in their
    entirety; this mode takes up a lot of screen space but makes it easier
    to see what the objects actually look like
  \item \dQuote{auto}: default mode; pick one of the above, will favor
    \dQuote{sidebyside} unless \code{getOption("width")} is less than 80,
    or in \code{diffPrint} and objects are dimensioned and do not fit side
    by side, or in \code{diffChr}, \code{diffDeparse}, \code{diffFile} and
    output does not fit in side by side without wrapping
}}

\item{context}{integer(1L) how many lines of context are shown on either side
of differences (defaults to 2).  Set to \code{-1L} to allow as many as
there are.  Set to \dQuote{auto}  to display as many as 10 lines or as few
as 1 depending on whether total screen lines fit within the number of lines
specified in \code{line.limit}.  Alternatively pass the return value of
\code{\link{auto_context}} to fine tune the parameters of the auto context
calculation.}

\item{format}{character(1L), controls the diff output format, one of:
\itemize{
  \item \dQuote{auto}: to select output format based on terminal
    capabilities; will attempt to use one of the ANSI formats if they
    appear to be supported, and if not will attempt to use HTML and
    browser output if in interactive mode.
  \item \dQuote{raw}: plain text
  \item \dQuote{ansi8}: color and format diffs using basic ANSI escape
    sequences
  \item \dQuote{ansi256}: like \dQuote{ansi8}, except using the full range
    of ANSI formatting options
  \item \dQuote{html}: color and format using HTML markup; the resulting
    string is processed with \code{\link{enc2utf8}} when output as a full
    web page (see docs for \code{html.output} under \code{\link{Style}}).
}
Defaults to \dQuote{auto}.  See \code{palette.of.styles} for details
on customization, \code{\link{style}} for full control of output format.}

\item{brightness}{character, one of \dQuote{light}, \dQuote{dark},
\dQuote{neutral}, useful for adjusting color scheme to light or dark
terminals.  \dQuote{neutral} by default.  See \code{\link{PaletteOfStyles}}
for details and limitations.  Advanced: you may specify brightness as a
function of \code{format}.  For example, if you typically wish to use a
\dQuote{dark} color scheme, except for when in \dQuote{html} format when
you prefer the \dQuote{light} scheme, you may use
\code{c("dark", html="light")} as the value for this parameter.  This is
particularly useful if \code{format} is set to \dQuote{auto} or if you
want to specify a default value for this parameter via options.  Any names
you use should correspond to a \code{format}.  You must have one unnamed
value which will be used as the default for all \code{format}s that are
not explicitly specified.}

\item{color.mode}{character, one of \dQuote{rgb} or \dQuote{yb}.
Defaults to \dQuote{yb}.  \dQuote{yb} stands for \dQuote{Yellow-Blue} for
color schemes that rely primarily on those colors to style diffs.
Those colors can be easily distinguished by individuals with
limited red-green color sensitivity.  See \code{\link{PaletteOfStyles}} for
details and limitations.  Also offers the same advanced usage as the
\code{brightness} parameter.}

\item{word.diff}{TRUE (default) or FALSE, whether to run a secondary word
diff on the in-hunk differences.  For atomic vectors setting this to
FALSE could make the diff \emph{slower} (see the \code{unwrap.atomic}
parameter).  For other uses, particularly with \code{\link{diffChr}}
setting this to FALSE can substantially improve performance.}

\item{pager}{one of \dQuote{auto} (default), \dQuote{on},
\dQuote{off}, or a \code{\link{Pager}} object; controls whether and how a
pager is used to display the diff output.  If \dQuote{on} will use the
pager associated with the \code{\link{Style}} specified via the
\code{\link{style}} parameters.  The default behavior is to use a pager if
either the R console does not support ANSI colors, or if the output of the
\code{diff*} methods would be taller than one screen.  If the system pager
is not known to support ANSI colors then we will try to display the output
in HTML with the IDE viewer if available or with the web browser if not.
See \code{\link{Pager}}, \code{\link{view_or_browse}}, \code{\link{Style}},
and \code{\link{PaletteOfStyles}} for more details and for instructions on
how to modify the default behavior.}

\item{guides}{TRUE (default), FALSE, or a function that accepts at least two
arguments and requires no more than two arguments.  Guides
are additional context lines that are not strictly part of a hunk, but
provide important contextual data (e.g. column headers).  If TRUE, the
context lines are shown in addition to the normal diff output, typically
in a different color to indicate they are not part of the hunk.  If a
function, the function should accept as the first argument the object
being diffed, and the second the character representation of the object.
The function should return the indices of the elements of the second
character representation that should be treated as guides.  See
\code{\link{guides}} for more details.}

\item{trim}{TRUE (default), FALSE, or a function that accepts at least two
arguments and requires no more than two arguments.  Function should compute
for each line in captured output what portion of those lines should be
diffed.  By default, this is used to remove row meta data differences
(e.g. \code{[1,]}) so they alone do not show up as differences in the
diff.  See \code{\link{trim}} for more details.}

\item{rds}{TRUE (default) or FALSE, if TRUE will check whether
\code{target} and/or \code{current} point to a file that can be read with
\code{\link{readRDS}} and if so, loads the R object contained in the file
and carries out the diff on the object instead of the original argument.
Currently there is no mechanism for specifying additional arguments to
\code{readRDS}}

\item{unwrap.atomic}{TRUE (default) or FALSE.  Only relevant for
\code{diffPrint}, if TRUE, and \code{word.diff} is also TRUE, and both
\code{target} and \code{current} are \emph{unnamed} and atomic, the vectors
are unwrapped and diffed element by element, and then re-wrapped.  Since
\code{diffPrint} is fundamentally a line diff, the re-wrapped lines are
lined up in a manner that is as consistent as possible with the unwrapped
diff.  Lines that contain the location of the word differences will be
paired up.  Since the vectors may well be wrapped with different
periodicities this will result in lines that are paired up that look like
they should not be paired up, though the locations of the differences
should be.  If is entirely possible that setting this parameter to FALSE
will result in a slower diff.  This happens if two vectors are actually
fairly similar, but their line representations are not.  For example, in
comparing \code{1:100} to \code{c(100, 1:99)}, there is really only one
difference at the \dQuote{word} level, but every screen line is different.}

\item{max.diffs}{integer(1L), number of \emph{differences} after which we
abandon the \code{O(n^2)} diff algorithm in favor of a linear one.  Set to
\code{-1L} to always stick to the original algorithm (defaults to 10000L).}

\item{disp.width}{integer(1L) number of display columns to take up; note that
in \dQuote{sidebyside} \code{mode} the effective display width is half this
number (set to 0L to use default widths which are \code{getOption("width")}
for normal styles and \code{80L} for HTML styles.}

\item{ignore.white.space}{TRUE or FALSE, whether to consider differences in
horizontal whitespace (i.e. spaces and tabs) as differences (defaults to
FALSE)}

\item{convert.hz.white.space}{TRUE or FALSE, whether modify input strings
that contain tabs and carriage returns in such a way that they display as
they would \bold{with} those characters, but without using those
characters (defaults to TRUE).  The conversion assumes that tab stops are
spaced evenly eight characters apart on the terminal.  If this is not the
case you may specify the tab stops explicitly with \code{tab.stops}.}

\item{tab.stops}{integer, what tab stops to use when converting hard tabs to
spaces.  If not integer will be coerced to integer (defaults to 8L).  You
may specify more than one tab stop.  If display width exceeds that
addressable by your tab stops the last tab stop will be repeated.}

\item{line.limit}{integer(2L) or integer(1L), if length 1 how many lines of
output to show, where \code{-1} means no limit.  If length 2, the first
value indicates the threshold of screen lines to begin truncating output,
and the second the number of lines to truncate to, which should be fewer
than the threshold.  Note that this parameter is implemented on a
best-efforts basis and should not be relied on to produce the exact
number of lines requested.  If you want a specific number of lines use
\code{[} or \code{head} / \code{tail}.  One advantage of \code{line.limit}
over these other options is that you can combine it with
\code{context="auto"} and auto \code{max.level} selection (the latter for
\code{diffStr}), which allows the diff to dynamically adjust to make best
use of the available display lines.  \code{[}, \code{head}, and \code{tail}
just subset the text of the output.}

\item{hunk.limit}{integer(2L) or integer (1L), how many diff hunks to show.
Behaves similarly to \code{line.limit}.  How many hunks are in a
particular diff is a function of how many differences, and also how much
\code{context} is used since context can cause two hunks to bleed into
each other and become one.}

\item{align}{numeric(1L) between 0 and 1, proportion of
words in a line of \code{target} that must be matched in a line of
\code{current} in the same hunk for those lines to be paired up when
displayed (defaults to 0.25), or an \code{\link{AlignThreshold}} object.
Set to \code{1} to turn off alignment which will cause all lines in a hunk
from \code{target} to show up first, followed by all lines from
\code{current}.  Note that in order to be aligned lines must meet the
threshold and have at least 3 matching alphanumeric characters (see
\code{\link{AlignThreshold}} for details).}

\item{style}{\dQuote{auto}, a \code{\link{Style}} object, or a list.
\dQuote{auto} by default.  If a \code{Style} object, will override the
the \code{format}, \code{brightness}, and \code{color.mode} parameters.
The \code{Style} object provides full control of diff output styling.
If a list, then the same as \dQuote{auto}, except that if the auto-selected
\code{Style} requires instantiation (see \code{\link{PaletteOfStyles}}),
then the list contents will be used as arguments when instantiating the
style object.  See \code{\link{Style}} for more details, in particular the
examples.}

\item{palette.of.styles}{\code{\link{PaletteOfStyles}} object; advanced usage,
contains all the \code{\link{Style}} objects or
\dQuote{classRepresentation} objects extending \code{\link{Style}} that are
selected by specifying the \code{format}, \code{brightness}, and
\code{color.mode} parameters.  See \code{\link{PaletteOfStyles}} for more
details.}

\item{frame}{an environment to use as the evaluation frame for the
\code{print/show/str}, calls and for \code{diffObj}, the evaluation frame
for the \code{diffPrint} / \code{diffStr} calls.  Defaults to the return
value of \code{\link{par_frame}}.}

\item{interactive}{TRUE or FALSE whether the function is being run in
interactive mode, defaults to the return value of
\code{\link{interactive}}.  If in interactive mode, pager will be used if
\code{pager} is \dQuote{auto}, and if ANSI styles are not supported and
\code{style} is \dQuote{auto}, output will be send to viewer/browser as
HTML.}

\item{term.colors}{integer(1L) how many ANSI colors are supported by the
terminal.  This variable is provided for when
\code{\link[=num_colors]{crayon::num_colors}} does not properly detect how
many ANSI colors are supported by your terminal. Defaults to return value
of \code{\link[=num_colors]{crayon::num_colors}} and should be 8 or 256 to
allow ANSI colors, or any other number to disallow them.  This only
impacts output format selection when \code{style} and \code{format} are
both set to \dQuote{auto}.}

\item{tar.banner}{character(1L), language, or NULL, used to generate the
text to display ahead of the diff section representing the target output.
If NULL will use the deparsed \code{target} expression, if language, will
use the language as it would the \code{target} expression, if
character(1L), will use the string with no modifications.  The language
mode is provided because \code{diffStr} modifies the expression prior to
display (e.g. by wrapping it in a call to \code{str}).  Note that it is
possible in some cases that the substituted value of \code{target} actually
is character(1L), but if you provide a character(1L) value here it will be
assumed you intend to use that value literally.}

\item{cur.banner}{character(1L) like \code{tar.banner}, but for
\code{current}}

\item{extra}{list additional arguments to pass on to the functions used to
create text representation of the objects to diff (e.g. \code{print},
\code{str}, etc.)}
}
\value{
a \code{Diff} object; see \code{\link{diffPrint}}.
}
\description{
Reads text files with \code{\link{readLines}} and performs a diff on the
resulting character vectors.
}
\examples{
\dontrun{
url.base <- "https://raw.githubusercontent.com/wch/r-source"
f1 <- file.path(url.base, "29f013d1570e1df5dc047fb7ee304ff57c99ea68/README")
f2 <- file.path(url.base, "daf0b5f6c728bd3dbcd0a3c976a7be9beee731d9/README")
diffFile(f1, f2)
}
}
\seealso{
\code{\link{diffPrint}} for details on the \code{diff*} functions,
  \code{\link{diffObj}}, \code{\link{diffStr}},
  \code{\link{diffChr}} to compare character vectors directly,
  \code{\link{ses}} for a minimal and fast diff
}
