% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilp_functions.R
\name{dilp_processing}
\alias{dilp_processing}
\title{Process raw leaf physiognomic data}
\usage{
dilp_processing(specimen_data)
}
\arguments{
\item{specimen_data}{A data frame containing specimen level leaf physiognomic
data. A good reference for how to put together the data: \code{\link{McAbeeExample}}}
}
\value{
A data frame containing cleaned and processed specimen level leaf
physiognomic data.  New variables calculated are:
\itemize{
\item Leaf area
\item Feret diameter
\item Feret diameter ratio (FDR)
\item Raw blade perimeter corrected (Raw blade perimeter - length of cut perimeter)
\item Internal raw blade perimeter corrected (Internal raw blade perimeter - length of cut perimeter)
\item Total tooth count
\item Total tooth count : internal perimeter (TC:IP)
\item Perimeter ratio
\item Petiole metric
\item Aspect ratio
\item Shape factor
\item Compactness
\item Tooth area
\item Tooth area : perimeter (TA:P)
\item Tooth area: internal perimeter (TA:IP)
\item Tooth area : blade area (TA:BA)
\item Average primary tooth area (Avg TA)
\item Tooth count : blade area (TC:BA)
\item Tooth count : perimeter (TC:P)
}
}
\description{
\code{dilp_processing()} will typically only be called internally by \code{dilp()}.
However, it can be used on its own to generate and view a processed DiLP
dataset that includes raw and derived physiognomic values useful for DiLP and
other physiognomic analyses.  Returns a data frame.
}
\examples{
dilp_dataset <- dilp_processing(McAbeeExample)
dilp_dataset
}
