% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_contributions}
\alias{plot_contributions}
\alias{plot_contributions-method}
\alias{plot_cos2}
\alias{plot_cos2-method}
\alias{plot_contributions,MultivariateAnalysis-method}
\alias{plot_cos2,MultivariateAnalysis-method}
\title{Visualize Contributions and cos2}
\usage{
plot_contributions(object, ...)

plot_cos2(object, ...)

\S4method{plot_contributions}{MultivariateAnalysis}(
  object,
  margin = 2,
  axes = 1,
  sort = TRUE,
  decreasing = TRUE,
  limit = 10,
  fill = "grey30",
  border = "grey10"
)

\S4method{plot_cos2}{MultivariateAnalysis}(
  object,
  margin = 2,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  sort = TRUE,
  decreasing = TRUE,
  limit = 10,
  fill = "grey30",
  border = "grey10"
)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-one \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{sort}{A \code{\link{logical}} scalar: should the data be sorted?}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be decreasing?
Only used if \code{sort} is \code{TRUE}.}

\item{limit}{An \code{\link{integer}} specifying the number of top elements to be
displayed.}

\item{fill, border}{A \code{\link{character}} string specifying the bars infilling and
border colors.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}
}
\description{
Plots contributions histogram and \eqn{cos^2}{cos2} scatterplot.
}
\examples{
## Load data
data("zuni", package = "folio")

## Compute correspondence analysis
X <- ca(zuni)

## Plot observations
plot(X)

## Screeplot
plot_variance(X)
}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}

Other plot: 
\code{\link{plot_coordinates}},
\code{\link{plot_eigenvalues}}
}
\author{
N. Frerebeau
}
\concept{plot}
