% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-swal-alert.R
\name{shiny_alert2}
\alias{shiny_alert2}
\alias{close_alert2}
\title{Simple shiny alert that uses 'JavaScript' promises}
\usage{
shiny_alert2(
  title = "Alert",
  text = "",
  icon = c("info", "warning", "success", "error"),
  danger_mode = FALSE,
  auto_close = TRUE,
  buttons = NULL,
  on_close = NULL,
  session = shiny::getDefaultReactiveDomain()
)

close_alert2()
}
\arguments{
\item{title}{title of the alert}

\item{text}{alert body text (pure text)}

\item{icon}{which icon to display, choices are \code{'info'},
\code{'success'} \code{'warning'}, and \code{'error'}}

\item{danger_mode}{true or false; if true, then the confirm button turns
red and the default focus is set on the cancel button instead. To enable
danger mode, \code{buttons} must be \code{TRUE} as well}

\item{auto_close}{whether to close automatically when clicking outside of
the alert}

\item{buttons}{logical value or a named list, or characters. If logical,
it indicates whether buttons should be displayed or not; for named list,
the names will be the button text, see example; for characters, the
characters will be the button text and value}

\item{on_close}{\code{NULL} or a function that takes in one argument. If
function is passed in, then it will be executed when users close the alert}

\item{session}{shiny session, see \code{\link[shiny]{domains}}}
}
\value{
a temporary input ID, currently not useful
}
\description{
Simple shiny alert that uses 'JavaScript' promises
}
\examples{

library(shiny)
library(dipsaus)
ui <- fluidPage(
  use_shiny_dipsaus(),
  actionButtonStyled('btn', 'btn')
)

server <- function(input, output, session) {
  observeEvent(input$btn, {
    shiny_alert2(
      on_close = function(value) {
        cat("Modal closed!\n")
        print(value)
      },
      title = "Title",
      text = "message",
      icon = "success",
      auto_close = FALSE,
      buttons = list("cancel" = TRUE,
                     "YES!" = list(value = 1))
    )
  })
}

if(interactive()){
  shinyApp(ui, server, options = list(launch.browser = TRUE))
}

}
