% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayStats.R
\name{pathwayStats}
\alias{pathwayStats}
\title{Pathway Level Statistics}
\usage{
pathwayStats(PGs, T, minSize=5, method="Stouffer")
}
\arguments{
\item{PGs}{an array of names indicating genes or substrates that belong to a given pathway or kinase.}

\item{T}{a vector of statistics (z-scores converted) with each element correspond to a gene or 
phosphorylation site that belong to the same pathway or kinase.}

\item{minSize}{the size of annotation groups to be considered for calculating enrichment. Groups 
that are smaller than the minSize will be removed from the analysis.}

\item{method}{the p-value integration method for combining accross multiple treatments. Available methods 
are Stouffer, OSP, Fisher, and maxP. The default method is Stouffer.}
}
\value{
a doublet corresponding to the enrichment after integration across all genes or substrates 
that belong to the same pathway or kinase, and the size of the mapped genes or substrates to that pathway
or kinase.
}
\description{
Takes a vector of statistics with each element corresponds to a gene or phosphorylation site, 
and calculates a combined statistics for those that belong to the same pathway or kinase.
}
\examples{
# load the example data
data(PM)

# load pathway annotations
data(Pathways)

# convert statistics into z-scores
PM.zscores <- apply(PM, 2, function(x){qnorm(rank(x)/(nrow(PM)+1))})

# Rotate the matrix by contrast 1, -1, -1 (i.e. up-regulation, down-regulation, dow-regulation).
PM.rotated <- rotate3d(PM.zscores, contrast = c(1, -1, -1))

# combine rotated statistics across treatments
gene.pvalues <- apply(PM.rotated, 1, geneStats)

# compute statistics for all reactome pathways
gene.zscores <- qnorm(gene.pvalues, lower.tail = FALSE)
gst <- t(sapply(Pathways.reactome, pathwayStats, gene.zscores))

}
